/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.strategy;

import com.xdja.log.config.Config;
import com.xdja.log.strategy.LogFileStrategy;
import com.xdja.log.util.LogFileUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class DefaultStrategy
implements LogFileStrategy {
    private static final int FILE_MAX_NUM = 10;
    private static final int FILE_MAX_SIZE = 1000000;
    private static final SimpleDateFormat LOG_FILE_DATE_FORMAT = new SimpleDateFormat("MM-dd-HH-mm");
    private File mCurrentLogFile;
    Config logConfig;
    private FileFilter fileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            String fileName = file.getName().toLowerCase();
            return fileName.endsWith(DefaultStrategy.this.logConfig.getSuffix());
        }
    };

    @Override
    public File outputFile(Config logConfig) throws IOException {
        this.logConfig = logConfig;
        if (this.mCurrentLogFile == null || this.mCurrentLogFile.length() >= 1000000L) {
            this.mCurrentLogFile = this.getNewLogFile();
        }
        return this.mCurrentLogFile;
    }

    private File getNewLogFile() {
        File lastLogFile;
        File dir = new File(this.logConfig.getAbsSubDirPath());
        File[] files = dir.listFiles(this.fileFilter);
        if (files == null || files.length == 0) {
            return this.createNewFile();
        }
        List<File> sortedFiles = this.sortFiles(files);
        if (files.length > 10) {
            LogFileUtils.delete(sortedFiles.get(0));
        }
        if ((lastLogFile = sortedFiles.get(sortedFiles.size() - 1)).length() < 1000000L) {
            return lastLogFile;
        }
        return this.createNewFile();
    }

    private File createNewFile() {
        return LogFileUtils.createFile(this.logConfig.getAbsSubDirPath() + File.separator + LOG_FILE_DATE_FORMAT.format(new Date()) + this.logConfig.getSuffix());
    }

    private List<File> sortFiles(File[] files) {
        List<File> fileList = Arrays.asList(files);
        Collections.sort(fileList, new FileComparator());
        return fileList;
    }

    private class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        @Override
        public int compare(File file1, File file2) {
            if (file1.lastModified() < file2.lastModified()) {
                return -1;
            }
            return 1;
        }
    }
}

