/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.util;

import android.text.TextUtils;
import java.io.File;
import java.io.FileWriter;

public class LogFileUtils {
    public static boolean makeDirectory(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return file.mkdirs();
        }
        return false;
    }

    public static synchronized boolean delete(File path) {
        File[] files;
        if (null == path) {
            return true;
        }
        if (path.isDirectory() && null != (files = path.listFiles())) {
            for (File file : files) {
                if (LogFileUtils.delete(file)) continue;
                return false;
            }
        }
        return !path.exists() || path.delete();
    }

    public static synchronized File createFile(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        File file = new File(path);
        if (file.isFile()) {
            return file;
        }
        File parentFile = file.getParentFile();
        if (parentFile != null && (parentFile.isDirectory() || parentFile.mkdirs())) {
            try {
                if (file.createNewFile()) {
                    return file;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String content, File file) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file, true);
            fileWriter.write(content);
            fileWriter.flush();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

