/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.util.Log;
import com.xdja.log.LogcatService;
import com.xdja.log.LogcatUtil;
import com.xdja.log.config.Config;
import com.xdja.log.exception.XdjaLogException;
import com.xdja.log.manager.CrashManager;
import com.xdja.log.manager.NormalManager;
import com.xdja.log.manager.ZipManager;
import java.io.File;
import java.io.IOException;

public class LogModule {
    static Config.Builder mBuilder;
    public static final String FILE_NAME = "xdja_log_config";
    private static final String LOG_LEVEL = "log_level";

    public static void initDefault(Context context) {
        if (context == null) {
            throw new XdjaLogException("context can not be null");
        }
        Config.Builder builder = new Config.Builder(context);
        builder.enableCollectCrash(true);
        File file = context.getExternalFilesDir("XDJALOG");
        if (file.exists()) {
            builder.setRootPath(file.getAbsolutePath());
        } else {
            boolean bool = file.mkdir();
            if (bool) {
                builder.setRootPath(file.getAbsolutePath());
            } else {
                Log.e((String)"WANGHAO", (String)"the root path of LogModule can not create");
            }
        }
        LogModule.initDefault(builder);
    }

    public static void initDefault(Config.Builder builder) {
        if (builder == null || builder.getContext() == null) {
            throw new XdjaLogException("params must not be null");
        }
        mBuilder = builder;
        NormalManager.getInstance().config(mBuilder);
        CrashManager.getInstance().config(mBuilder);
        ZipManager.getInstance().config(mBuilder);
        if (LogModule.systemLogIsEnable(builder.getContext())) {
            LogModule.openCollectSystemLog(builder.getContext());
        }
    }

    public static String getRootPath() {
        if (mBuilder == null) {
            return "";
        }
        return mBuilder.build().getRootPath();
    }

    public static String getLogcatPath() {
        return LogcatUtil.getFilePath();
    }

    public static String getCrashPath() {
        return CrashManager.getInstance().getPath();
    }

    public static String getNormalPath() {
        return NormalManager.getInstance().getPath();
    }

    public static String getZipPath() {
        return ZipManager.getInstance().getPath();
    }

    public static void enableSystemLog(Context context) {
        SharedPreferences preferences = context.getSharedPreferences(FILE_NAME, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt(LOG_LEVEL, 1);
        editor.commit();
    }

    public static void disableSystemLog(Context context) {
        SharedPreferences preferences = context.getSharedPreferences(FILE_NAME, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt(LOG_LEVEL, 5);
        editor.commit();
    }

    public static boolean systemLogIsEnable(Context context) {
        int level = LogModule.getLogLevel(context);
        return level == 1;
    }

    public static int getLogLevel(Context context) {
        SharedPreferences preferences = context.getSharedPreferences(FILE_NAME, 0);
        return preferences.getInt(LOG_LEVEL, 5);
    }

    public static void openCollectSystemLog(Context context) {
        Intent intent = new Intent(context, LogcatService.class);
        context.startService(intent);
    }

    public static void closeCollectSystemLog(Context context) {
        Intent intent = new Intent(context, LogcatService.class);
        context.stopService(intent);
    }

    public static String exportLogPath() throws IOException {
        return ZipManager.getInstance().exportZipLog();
    }
}

