/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import com.xdja.log.LogcatUtil;
import com.xdja.log.XdjaLog;
import java.io.File;

public class LogcatService
extends Service {
    private static final String THIS_FILE = "LogcatService";
    private boolean stop = false;
    private int maxFileCount = 4;
    private long maxFileSize = 0x2000000L;
    private static final String BACKUP_PREFIX = "log_backup_";

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        super.onCreate();
        boolean success = LogcatUtil.startCapture();
        if (!success) {
            XdjaLog.e(THIS_FILE, "Error to start capture logcat!");
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!LogcatService.this.stop) {
                        File logFile = LogcatUtil.getLogFile();
                        if (logFile.length() >= LogcatService.this.maxFileSize) {
                            XdjaLog.d(LogcatService.THIS_FILE, "Log file size exceed! Backup file");
                            LogcatUtil.stopCapture();
                            LogcatService.this.backupLogFile(logFile);
                            LogcatUtil.startCapture();
                        }
                        Process process = LogcatUtil.getProcess();
                        boolean isAlive = false;
                        try {
                            int exitValue = process.exitValue();
                            if (exitValue != 0) {
                                isAlive = false;
                            }
                        }
                        catch (IllegalThreadStateException e) {
                            isAlive = true;
                        }
                        if (!isAlive) {
                            XdjaLog.e(LogcatService.THIS_FILE, "Logcat thread died!!!");
                            LogcatUtil.resumeCapture();
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    XdjaLog.d(LogcatService.THIS_FILE, "Logcat thread normal stop!!!");
                }
            }).start();
        }
    }

    private void backupLogFile(File logFile) {
        String logPath = LogcatUtil.getFilePath();
        if (!new File(logPath).exists()) {
            XdjaLog.e(THIS_FILE, "Error!! Log file path not exists");
            return;
        }
        for (int index = 0; index < this.maxFileCount; ++index) {
            String backupName = logPath + BACKUP_PREFIX + index + ".log";
            File file = new File(backupName);
            if (file.exists()) continue;
            XdjaLog.d(THIS_FILE, "Backup file " + logFile.getAbsolutePath() + "  to  " + backupName);
            logFile.renameTo(file);
            return;
        }
        XdjaLog.d(THIS_FILE, "Backup file is full. Delete first and rename current log file");
        String firstBackupName = logPath + BACKUP_PREFIX + "0.log";
        File firtFile = new File(firstBackupName);
        firtFile.delete();
        for (int index = 1; index < this.maxFileCount; ++index) {
            String backupName = logPath + BACKUP_PREFIX + index + ".log";
            File file = new File(backupName);
            file.renameTo(new File(logPath + BACKUP_PREFIX + (index - 1) + ".log"));
        }
        String currentBackupName = logPath + BACKUP_PREFIX + (this.maxFileCount - 1) + ".log";
        logFile.renameTo(new File(currentBackupName));
    }

    public void onDestroy() {
        super.onDestroy();
        this.stop = true;
        LogcatUtil.stopCapture();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return super.onStartCommand(intent, flags, startId);
    }
}

