/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log;

import com.xdja.log.LogModule;
import com.xdja.log.XdjaLog;
import com.xdja.log.util.FileUtil;
import java.io.File;
import java.io.IOException;

public class LogcatUtil {
    private static final String THIS_FILE = "LogcatUtil";
    private static final String TEMP_LOG = "logcat_tmp.log";
    private static String filePath = LogModule.getRootPath() + File.separator + "logcat" + File.separator;
    private static File logFile = null;
    private static Process process = null;
    private static boolean running = false;

    public static String getFilePath() {
        return filePath;
    }

    public static void setFilePath(String path) {
        filePath = path;
    }

    public static Process getProcess() {
        return process;
    }

    public static File getLogFile() {
        return logFile;
    }

    public static void cleanHistory() {
        FileUtil.deleteFilesBefore(filePath, 345600000L);
    }

    public static boolean startCapture() {
        LogcatUtil.cleanHistory();
        if (running) {
            XdjaLog.d(THIS_FILE, "Loggcat capture is already running");
            return true;
        }
        File path = new File(filePath);
        if (!path.exists()) {
            path.mkdirs();
        }
        logFile = new File(path, TEMP_LOG);
        try {
            process = Runtime.getRuntime().exec("logcat -c");
            process = Runtime.getRuntime().exec("logcat -f " + logFile);
        }
        catch (IOException e) {
            XdjaLog.e(THIS_FILE, "Trye to capture app logcat failed. IO exception");
            e.printStackTrace();
            return false;
        }
        running = true;
        return true;
    }

    public static boolean resumeCapture() {
        if (logFile != null) {
            try {
                process = Runtime.getRuntime().exec("logcat -c");
                process = Runtime.getRuntime().exec("logcat -f " + logFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static void stopCapture() {
        if (process != null) {
            process.destroy();
        }
        logFile = null;
        running = false;
    }
}

