/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log;

import android.util.Log;
import com.xdja.log.config.LogLevel;
import com.xdja.log.manager.NormalManager;

public class PrintDispatcher {
    static void execute(LogLevel level, String tag, String msg) {
        PrintDispatcher.printToConsole(level, tag, msg);
        PrintDispatcher.writeToFile(level, tag, msg);
    }

    static void writeToFile(LogLevel level, String tag, String message) {
        NormalManager.getInstance().writeToFileIfNeeded(level, tag, message);
    }

    static void printToConsole(LogLevel level, String tag, String msg) {
        switch (level) {
            case VERBOSE: {
                Log.v((String)tag, (String)msg);
                break;
            }
            case DEBUG: {
                Log.d((String)tag, (String)msg);
                break;
            }
            case INFO: {
                Log.i((String)tag, (String)msg);
                break;
            }
            case WARN: {
                Log.w((String)tag, (String)msg);
                break;
            }
            case ERROR: {
                Log.e((String)tag, (String)msg);
                break;
            }
        }
    }
}

