/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.config;

import android.content.Context;
import java.io.File;

public class Config {
    private String rootPath;
    private String suffix;
    private String subDirPath;
    private boolean collectCrash;
    private Context context;

    private Config(Builder builder) {
        this.context = builder.context;
        this.rootPath = builder.rootPath;
        if (this.rootPath == null || this.rootPath.length() <= 0) {
            this.rootPath = this.context.getPackageName();
        }
        this.subDirPath = builder.subDirPath;
        this.suffix = builder.suffix;
        this.collectCrash = builder.collectCrash;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public String getAbsSubDirPath() {
        return this.getRootPath() + File.separator + this.subDirPath;
    }

    public String getZipAbsPath() {
        return this.getAbsSubDirPath() + File.separator + "zip" + this.suffix;
    }

    public boolean isCollectCrash() {
        return this.collectCrash;
    }

    public Context getContext() {
        return this.context;
    }

    public static class Builder {
        Context context;
        String rootPath;
        String subDirPath;
        boolean collectCrash;
        String suffix;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setRootPath(String rootPath) {
            this.rootPath = rootPath;
            return this;
        }

        public Builder setSubDirPath(String subDirPath) {
            this.subDirPath = subDirPath;
            return this;
        }

        public Builder setSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public Builder enableCollectCrash(boolean enable) {
            this.collectCrash = enable;
            return this;
        }

        public Context getContext() {
            return this.context;
        }

        public Config build() {
            return new Config(this);
        }
    }
}

