/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.manager;

import android.os.Process;
import com.xdja.log.config.Config;
import com.xdja.log.config.ILogConfig;
import com.xdja.log.config.LogLevel;
import com.xdja.log.exception.XdjaLogException;
import com.xdja.log.strategy.DefaultStrategy;
import com.xdja.log.strategy.LogFileStrategy;
import com.xdja.log.util.LogFileUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CrashManager
implements Thread.UncaughtExceptionHandler,
ILogConfig {
    private static final SimpleDateFormat LOG_DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final SimpleDateFormat FILE_NAME = new SimpleDateFormat("yyyy-MM-DD-HH-MM");
    LogFileStrategy strategy;
    Config config;

    public LogFileStrategy strategy() {
        if (this.strategy == null) {
            this.strategy = new DefaultStrategy();
        }
        return this.strategy;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        PrintWriter printWriter = null;
        Writer writer = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("\n");
            sb.append(this.formatLog());
            writer = new StringWriter();
            printWriter = new PrintWriter(writer);
            ex.printStackTrace(printWriter);
            sb.append(writer.toString());
            File file = this.strategy().outputFile(this.config);
            FileWriter fw = new FileWriter(file, true);
            BufferedWriter bufferedWriter = new BufferedWriter(fw);
            bufferedWriter.append(sb);
            bufferedWriter.flush();
            bufferedWriter.close();
            File newFile = new File(this.config.getAbsSubDirPath() + File.separator + FILE_NAME.format(new Date()) + this.config.getSuffix());
            file.renameTo(newFile);
        }
        catch (Exception e) {
            throw new XdjaLogException("printWrite throws exception");
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Process.killProcess((int)Process.myPid());
        }
    }

    public void config(Config.Builder builder) {
        builder.setSuffix(".log");
        builder.setSubDirPath("crash");
        this.config = builder.build();
        if (this.config.isCollectCrash()) {
            Thread.setDefaultUncaughtExceptionHandler(this);
            LogFileUtils.makeDirectory(this.config.getAbsSubDirPath());
        }
    }

    private String formatLog() {
        return String.format("%s %d %d %s ", LOG_DATE_TIME_FORMAT.format(new Date()) + "  ", Process.myPid(), Thread.currentThread().getId(), LogLevel.ERROR.getDesc());
    }

    @Override
    public String getPath() {
        return this.config.getAbsSubDirPath();
    }

    public static CrashManager getInstance() {
        return CrashManagerHolder.INSTANCE;
    }

    private CrashManager() {
    }

    static class CrashManagerHolder {
        static CrashManager INSTANCE = new CrashManager();

        CrashManagerHolder() {
        }
    }
}

