/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.manager;

import android.os.Process;
import android.util.Log;
import com.xdja.log.config.Config;
import com.xdja.log.config.ILogConfig;
import com.xdja.log.config.LogLevel;
import com.xdja.log.strategy.DefaultStrategy;
import com.xdja.log.strategy.LogFileStrategy;
import com.xdja.log.util.LogFileUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class NormalManager
implements ILogConfig {
    private static final SimpleDateFormat LOG_DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static ExecutorService sLogExecutor = Executors.newSingleThreadExecutor();
    final String subDir = "normal";
    final String suffix = ".log";
    LogFileStrategy strategy;
    Config config;

    public LogFileStrategy strategy() {
        if (this.strategy == null) {
            this.strategy = new DefaultStrategy();
        }
        return this.strategy;
    }

    public void writeToFileIfNeeded(final LogLevel level, final String tag, final String message) {
        sLogExecutor.execute(new Runnable(){

            @Override
            public void run() {
                String logMsg = NormalManager.this.formatLog(level, tag, message);
                try {
                    File file = NormalManager.this.strategy().outputFile(NormalManager.this.config);
                    LogFileUtils.writeToFile(logMsg, file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private String formatLog(LogLevel level, String tag, String msg) {
        return String.format("%s %d %d %s tag:%s content:%s\n", LOG_DATE_TIME_FORMAT.format(new Date()) + "  ", Process.myPid(), Thread.currentThread().getId(), level.getDesc(), tag, msg);
    }

    public void config(Config.Builder builder) {
        builder.setSuffix(".log");
        builder.setSubDirPath("normal");
        this.config = builder.build();
        Log.i((String)"WANGHAO", (String)this.config.getAbsSubDirPath());
        LogFileUtils.makeDirectory(this.config.getAbsSubDirPath());
    }

    @Override
    public String getPath() {
        return this.config.getAbsSubDirPath();
    }

    public static NormalManager getInstance() {
        return NormalManagerHolder.instance;
    }

    private NormalManager() {
    }

    static class NormalManagerHolder {
        static NormalManager instance = new NormalManager();

        NormalManagerHolder() {
        }
    }
}

