/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.manager;

import com.xdja.log.config.Config;
import com.xdja.log.config.ILogConfig;
import com.xdja.log.strategy.LogFileStrategy;
import com.xdja.log.strategy.ZipFileStrategy;
import com.xdja.log.util.LogFileUtils;
import java.io.IOException;

public class ZipManager
implements ILogConfig {
    LogFileStrategy strategy;
    Config config;
    final String subDir = "zip";
    final String suffix = ".zip";

    public LogFileStrategy strategy() {
        if (this.strategy == null) {
            this.strategy = new ZipFileStrategy();
        }
        return this.strategy;
    }

    public String exportZipLog() throws IOException {
        return this.strategy().outputFile(this.config).getPath();
    }

    public void config(Config.Builder builder) {
        builder.setSubDirPath("zip");
        builder.setSuffix(".zip");
        this.config = builder.build();
        LogFileUtils.makeDirectory(this.config.getAbsSubDirPath());
    }

    @Override
    public String getPath() {
        return this.config.getAbsSubDirPath();
    }

    public static ZipManager getInstance() {
        return ZipManagerHolder.instance;
    }

    private ZipManager() {
    }

    static class ZipManagerHolder {
        static ZipManager instance = new ZipManager();

        ZipManagerHolder() {
        }
    }
}

