/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.strategy;

import com.xdja.log.config.Config;
import com.xdja.log.strategy.LogFileStrategy;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipFileStrategy
implements LogFileStrategy {
    @Override
    public File outputFile(Config logConfig) throws IOException {
        File distOutFile = new File(logConfig.getZipAbsPath());
        if (distOutFile.isFile() && distOutFile.exists()) {
            distOutFile.delete();
        }
        ZipOutputStream distOutputStream = new ZipOutputStream(new FileOutputStream(distOutFile));
        File source = new File(logConfig.getRootPath());
        if (source.isDirectory()) {
            this.compress(distOutputStream, source, "");
        } else {
            File[] entries = source.listFiles();
            for (int i = 0; i < entries.length; ++i) {
                this.compress(distOutputStream, entries[i], "");
            }
        }
        distOutputStream.close();
        return distOutFile;
    }

    void compress(ZipOutputStream zipOutputStream, File file, String filePath) throws IOException {
        if (file.isDirectory()) {
            File[] fileList;
            for (File temp : fileList = file.listFiles()) {
                if (temp.getName().equals("zip")) continue;
                this.compress(zipOutputStream, temp, filePath + file.getName() + "/");
            }
        } else {
            int len;
            zipOutputStream.putNextEntry(new ZipEntry(filePath + file.getName()));
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            byte[] buffer = new byte[2048];
            while ((len = bufferedInputStream.read(buffer)) != -1) {
                zipOutputStream.write(buffer, 0, len);
            }
            bufferedInputStream.close();
            fileInputStream.close();
        }
    }
}

