package com.xdja.log;

import com.xdja.log.internal.DefaultsFactory;
import com.xdja.log.printer.AndroidPrinter;
import com.xdja.log.printer.Printer;
import com.xdja.log.printer.PrinterSet;
import com.xdja.log.printer.file.FilePrinter;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by hyh on 2021/1/14
 */
class Logger implements ILogger, ILog {

    private Printer printer;

    private LogConfiguration logConfiguration;

    private String logPath;

    public Logger(LogConfiguration logConfiguration) {
        updateConfigLog(logConfiguration);
    }

    @Override
    public void i(String tag, String message) {
        println(LogLevel.INFO.level, tag, message);
    }

    @Override
    public void d(String tag, String message) {
        println(LogLevel.DEBUG.level, tag, message);
    }

    @Override
    public void e(String tag, String message) {
        println(LogLevel.ERROR.level, tag, message);
    }

    @Override
    public void v(String tag, String message) {
        println(LogLevel.VERBOSE.level, tag, message);
    }

    @Override
    public void w(String tag, String message) {
        println(LogLevel.WARN.level, tag, message);
    }

    private void println(int logLevel, String tag, String message) {
        if (logLevel < logConfiguration.logLevel) {
            return;
        }
        printer.println(logLevel, tag, message);
    }

    @Override
    public void updateConfigLog(LogConfiguration configuration) {
        this.logConfiguration = configuration;
        logPath = new File(logConfiguration.rootPath, LogConfiguration.LOG_NORMAL).getAbsolutePath();
        List<Printer> printerList = new ArrayList<>();
        if (logConfiguration.allowedPrintConsole) {
            printerList.add(new AndroidPrinter());
        }
        if (logConfiguration.allowedWriteFile) {
            printerList.add(new FilePrinter.
                    Builder(logPath)
                    .fileNameGenerator(DefaultsFactory.createFileNameGenerator())
                    .backupStrategy(DefaultsFactory.createBackupStrategy())
                    .cleanStrategy(DefaultsFactory.createCleanStrategy())
                    .build());
        }
        this.printer = new PrinterSet(printerList);
    }

    @Override
    public String getLogPath() {
        return logPath;
    }
}
