package com.xdja.log;

import com.xdja.log.crash.CrashLogger;
import com.xdja.log.internal.DefaultsFactory;
import com.xdja.log.printer.AndroidPrinter;
import com.xdja.log.printer.Printer;
import com.xdja.log.printer.PrinterSet;
import com.xdja.log.printer.file.FilePrinter;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hyh
 * data on 2021/1/18
 */
class XdjaCrashLog implements ILog {
    private static final String TAG = "XdjaCrashLog";

    private Printer printer;

    private String crashLogPath;

    public XdjaCrashLog(LogConfiguration configuration) {
        updateConfigLog(configuration);
    }

    @Override
    public void updateConfigLog(LogConfiguration configuration) {
        if (configuration == null) {
            XdjaLog.e(TAG, "crash log config is empty");
            return;
        }
        crashLogPath = new File(configuration.rootPath, LogConfiguration.LOG_CRASH).getAbsolutePath();
        if (configuration.enableCollectCrash) {
            List<Printer> printerList = new ArrayList<>();
            printerList.add(new FilePrinter.
                    Builder(crashLogPath)
                    .keepOpen(false)
                    .useWork(false)
                    .fileNameGenerator(DefaultsFactory.createFileNameGenerator())
                    .backupStrategy(DefaultsFactory.createBackupStrategy())
                    .cleanStrategy(DefaultsFactory.createCleanStrategy())
                    .build());
            printer = new PrinterSet(printerList);
            openCrashLog();
        } else {
            printer=null;
            CrashLogger.getInstance().closeCrashLog();
            XdjaLog.d(TAG, "disable collect crash");
        }
    }

    @Override
    public String getLogPath() {
        return crashLogPath;
    }

    /**
     * 开启Crash日志
     */
    public void openCrashLog() {
        if (printer != null) {
            CrashLogger.getInstance().openCrashLog(printer);
        }
    }

}
