package com.xdja.log;

import com.xdja.log.internal.DefaultsFactory;
import com.xdja.log.logcat.LogcatFileOutput;
import com.xdja.log.logcat.LogcatLogger;
import com.xdja.log.printer.file.naming.LogcatFileNameGenerator;

import java.io.File;

/**
 * @author hyh
 * data on 2021/1/18
 */
class XdjaLogcat implements ILog {
    private static final String TAG = "XdjaLogCat";

    private String logCatPath;

    private LogcatFileOutput logcatFileOutput;

    public XdjaLogcat(LogConfiguration configuration) {
        updateConfigLog(configuration);
    }

    @Override
    public void updateConfigLog(LogConfiguration configuration) {
        logCatPath = new File(configuration.rootPath, LogConfiguration.LOG_LOGCAT).getAbsolutePath();
        logcatFileOutput = new LogcatFileOutput.
                Builder(logCatPath)
                .backupStrategy(DefaultsFactory.createBackupStrategy())
                .cleanStrategy(DefaultsFactory.createCleanStrategy())
                .fileNameGenerator(new LogcatFileNameGenerator())
                .build();
    }

    @Override
    public String getLogPath() {
        return logCatPath;
    }

    /**
     * 开启logCat日志输出
     * @return
     */
    public boolean startLogCatOutput() {
        if (logcatFileOutput != null) {
            XdjaLog.e(TAG, "start logcat output");
            return LogcatLogger.getInstance().startLogCatOutput(logcatFileOutput);
        } else {
            XdjaLog.e(TAG, "logcat output printer is empty");
            return false;
        }

    }

    /**
     * 关闭logCat日志输出
     */
    public void stopLogCatOutput() {
        XdjaLog.e(TAG, "stop logcat output");
        LogcatLogger.getInstance().stopLogCatOutput();
    }


}
