package com.xdja.log.crash;

import android.util.Log;

import com.xdja.log.LogLevel;
import com.xdja.log.printer.Printer;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

/**
 * @author hyh
 * data on 2021/1/15
 */
public class CrashLogger implements Thread.UncaughtExceptionHandler {

    private static final String TAG="CrashLog";

    private Printer mPrinter;

    public void openCrashLog(Printer printer) {
        if (this.mPrinter != null) {
            this.mPrinter.stopPrint();
        }
        this.mPrinter = printer;
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    public void closeCrashLog() {
        if (mPrinter != null) {
            mPrinter.stopPrint();
            mPrinter=null;
        }
    }


    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        PrintWriter printWriter = null;
        Writer writer = null;
        try {
            StringBuffer msg = new StringBuffer();
            msg.append("\n");
            writer = new StringWriter();
            printWriter = new PrintWriter(writer);
            throwable.printStackTrace(printWriter);
            msg.append(writer.toString());
            println(LogLevel.ERROR.getLevel(), LogLevel.ERROR.getDesc(), msg.toString());
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            android.os.Process.killProcess(android.os.Process.myPid());
        }
    }

    private void println(int logLevel, String tag, String message) {
        if (mPrinter != null) {
            mPrinter.println(logLevel, tag, message);
        }
        Log.e(TAG,message);
    }

    static class CrashLoggerHolder {
        static CrashLogger INSTANCE = new CrashLogger();
    }

    public static CrashLogger getInstance() {
        return CrashLoggerHolder.INSTANCE;
    }

    private CrashLogger() {
    }
}
