/*
 * Copyright 2016 Elvis Hew
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.xdja.log.internal;

import com.xdja.log.flattener.Flattener2;
import com.xdja.log.flattener.PatternFlattener;
import com.xdja.log.printer.file.FilePrinter;
import com.xdja.log.printer.file.backup.BackupStrategy;
import com.xdja.log.printer.file.backup.FileSizeBackupStrategy;
import com.xdja.log.printer.file.clean.CleanStrategy;
import com.xdja.log.printer.file.clean.FileLastModifiedCleanStrategy;
import com.xdja.log.printer.file.naming.DateFileNameGenerator;
import com.xdja.log.printer.file.naming.FileNameGenerator;

/**
 * Factory for providing default implementation.
 */
public class DefaultsFactory {

    public static final String DEFAULT_LOG_FILE_NAME = "log";

    public static final long DEFAULT_LOG_FILE_MAX_SIZE = 10 * 1024 * 1024;
    public static final long DEFAULT_LOG_FILE_MAX_TIME = 1000 * 60 * 60 * 24 * 7;

    /**
     * Create the default {@link Flattener2}.
     */
    public static Flattener2 createFlattener2() {
        return new PatternFlattener("{d yyyy-MM-dd HH:mm:ss.SSS} {l}/{t}: {m}");
    }


    /**
     * Create the default file name generator for {@link FilePrinter}.
     */
    public static FileNameGenerator createFileNameGenerator() {
        return new DateFileNameGenerator();
    }

    /**
     * Create the default backup strategy for {@link FilePrinter}.
     */
    public static BackupStrategy createBackupStrategy() {
        return new FileSizeBackupStrategy(DEFAULT_LOG_FILE_MAX_SIZE);
    }

    /**
     * Create the default clean strategy for {@link FilePrinter}.
     */
    public static CleanStrategy createCleanStrategy() {
        return new FileLastModifiedCleanStrategy(DEFAULT_LOG_FILE_MAX_TIME);
    }

}
