package com.xdja.log.logcat;

import android.os.SystemClock;

import com.xdja.log.XdjaLog;

import java.io.IOException;

/**
 * @author hyh
 * data on 2021/1/15
 */
public class LogcatLogger {
    private static final String THIS_FILE = "LogcatLogger";

    private boolean running = false;

    private static Process process = null;


    private boolean threadEnd = true;


    /**
     * logcat日志操作
     *
     * @param logcatFileOutput 根据当前策略，进行logcat日志的备份和清除
     * @return
     */
    public synchronized boolean startLogCatOutput(final LogcatFileOutput logcatFileOutput) {
        if (running) {
            XdjaLog.d(THIS_FILE, "Loggcat capture is already running");
            return true;
        }
        if (logcatFileOutput == null) {
            XdjaLog.d(THIS_FILE, "Loggcat file config is empty");
            return false;
        }
        final String logPath = logcatFileOutput.getCurrentLogcatPath().getAbsolutePath();
        boolean success = startCapture(logPath);
        if (!success) {
            XdjaLog.e(THIS_FILE, "Error to start capture logcat!");
            return false;
        } else {
            if (threadEnd) {
                XdjaLog.d(THIS_FILE, "start logcat thread");
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        threadEnd=false;
                        while (running) {
                            logcatFileOutput.logcatFileOperation(new LogcatFileOutput.ILogcatEvent() {
                                @Override
                                public void open() {
                                    startCapture(logPath);
                                }

                                @Override
                                public void close() {
                                    stopCapture();
                                }
                            });

                            if (!logcatProcessIsAlive()) {
                                XdjaLog.e(THIS_FILE, "Logcat thread died!!!");
                                startCapture(logPath);
                            }
                            SystemClock.sleep(1000);
                        }
                        threadEnd=true;
                    }
                }).start();
            }

            running = true;
        }
        return true;
    }

    /**
     * logcat进程是否活着
     * @return
     */
    private boolean logcatProcessIsAlive() {
        boolean isAlive = false;
        try {
            int exitValue = process.exitValue();
            if (exitValue != 0) {
                isAlive = false;
            }
        } catch (IllegalThreadStateException e) {
            e.printStackTrace();
            isAlive = true;
        }
        return isAlive;
    }

    /**
     * 开启logcat日志进程
     *
     * @param logPath 日志路径
     * @return
     */
    private boolean startCapture(String logPath) {
        try {
            stopCapture();
            process = Runtime.getRuntime().exec("logcat -c");
            process = Runtime.getRuntime().exec("logcat -f " + logPath);
        } catch (IOException e) {
            XdjaLog.e(THIS_FILE, "Trye to capture app logcat failed. IO exception");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /**
     * 关闭logcat日志进程
     */
    private void stopCapture() {
        if (process != null) {
            process.destroy();
        }
    }

    public void stopLogCatOutput() {
        stopCapture();
        running = false;
    }


    static class LogcatLoggerHolder {
        static LogcatLogger INSTANCE = new LogcatLogger();
    }

    public static LogcatLogger getInstance() {
        return LogcatLoggerHolder.INSTANCE;
    }

    private LogcatLogger() {
    }

}
