package com.xdja.log.printer;

import java.util.List;

public class PrinterSet implements Printer {

    private List<Printer> printers;

    public PrinterSet(List<Printer> printers) {
        this.printers = printers;
    }

    @Override
    public void println(int logLevel, String tag, String msg) {
        for (Printer printer : printers) {
            printer.println(logLevel, tag, msg);
        }
    }

    @Override
    public void stopPrint() {
        if (printers != null) {
            for (Printer printer : printers) {
                printer.stopPrint();
            }
        }
    }
}
