package com.xdja.log.store;

import android.content.Context;
import android.content.SharedPreferences;

import static android.content.Context.MODE_PRIVATE;

/**
 * 日志模块的存储，用于存储{@link com.xdja.log.LogConfiguration}中字段
 * <p>
 * 使用SharedPreferences存储
 *
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2021/1/14 <br/>
 */
public class Store {
    private final static String NAME = "XdjaLog";

    public static void put(Context context, String key, String value) {
        if (context == null) {
            throw new NullPointerException(Store.class.getName() + " put(): context is null!");
        }
        SharedPreferences.Editor edit = context.getSharedPreferences(NAME, MODE_PRIVATE).edit();
        edit.putString(key, value);
        edit.apply();
    }

    public static void put(Context context, String key, int value) {
        if (context == null) {
            throw new NullPointerException(Store.class.getName() + " put(): context is null!");
        }
        SharedPreferences.Editor edit = context.getSharedPreferences(NAME, MODE_PRIVATE).edit();
        edit.putInt(key, value);
        edit.apply();
    }

    public static void put(Context context, String key, boolean value) {
        if (context == null) {
            throw new NullPointerException(Store.class.getName() + " put(): context is null!");
        }
        SharedPreferences.Editor edit = context.getSharedPreferences(NAME, MODE_PRIVATE).edit();
        edit.putBoolean(key, value);
        edit.apply();
    }

    public static String getString(Context context, String key, String defaultValue) {
        if (context == null) {
            throw new NullPointerException(Store.class.getName() + " getString(): context is null!");
        }
        SharedPreferences preferences = context.getSharedPreferences(NAME, MODE_PRIVATE);
        return preferences.getString(key, defaultValue);
    }

    public static int getInt(Context context, String key, int defaultValue) {
        if (context == null) {
            throw new NullPointerException(Store.class.getName() + " getInt(): context is null!");
        }
        SharedPreferences preferences = context.getSharedPreferences(NAME, MODE_PRIVATE);
        return preferences.getInt(key, defaultValue);
    }

    public static boolean getBoolean(Context context, String key, boolean defaultValue) {
        if (context == null) {
            throw new NullPointerException(Store.class.getName() + " getInt(): context is null!");
        }
        SharedPreferences preferences = context.getSharedPreferences(NAME, MODE_PRIVATE);
        return preferences.getBoolean(key, defaultValue);
    }

}
