/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log;

import android.content.Context;
import android.text.TextUtils;
import com.xdja.log.LogLevel;
import com.xdja.log.store.Store;

public class LogConfiguration
implements Cloneable {
    private static final String KEY_LOG_LEVEL = "logLevel";
    private static final String KEY_WRITE_LOG_TO_FILE = "writeLogToFile";
    private static final String KEY_PRINT_CONSOLE = "printConsole";
    private static final String KEY_COLLECT_CRASH = "collectCrash";
    private static final String KEY_ROOT_PATH = "rootPath";
    private static final String ROOT_PATH_NAME = "XDJALOG";
    public static final String LOG_NORMAL = "normal";
    public static final String LOG_CRASH = "crash";
    public static final String LOG_LOGCAT = "logcat";
    public Context context;
    public int logLevel;
    public String rootPath;
    public boolean enableCollectCrash;
    public boolean allowedWriteFile;
    public boolean allowedPrintConsole;
    public boolean once;

    public LogConfiguration(Builder builder) {
        this.context = builder.context;
        this.logLevel = builder.logLevel;
        this.rootPath = TextUtils.isEmpty((CharSequence)builder.rootPath) ? this.context.getExternalFilesDir(ROOT_PATH_NAME).getAbsolutePath() : builder.rootPath;
        this.enableCollectCrash = builder.enableCollectCrash;
        this.allowedWriteFile = builder.allowedWriteFile;
        this.allowedPrintConsole = builder.allowedPrintConsole;
        this.once = builder.once;
    }

    void store() {
        Store.put(this.context, KEY_LOG_LEVEL, this.logLevel);
        Store.put(this.context, KEY_WRITE_LOG_TO_FILE, this.allowedWriteFile);
        Store.put(this.context, KEY_PRINT_CONSOLE, this.allowedPrintConsole);
        Store.put(this.context, KEY_COLLECT_CRASH, this.enableCollectCrash);
        Store.put(this.context, KEY_ROOT_PATH, this.rootPath);
    }

    public int hashCode() {
        int result = 0;
        result += this.enableCollectCrash ? 1 : 0;
        result += this.allowedWriteFile ? 2 : 0;
        result += this.allowedPrintConsole ? 4 : 0;
        result += this.once ? 8 : 0;
        result += this.logLevel * 100;
        return result += this.rootPath.hashCode() * 13;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfiguration)) {
            return false;
        }
        LogConfiguration other = (LogConfiguration)obj;
        return other.allowedPrintConsole == this.allowedPrintConsole && other.allowedWriteFile == this.allowedWriteFile && other.enableCollectCrash == this.enableCollectCrash && other.once == this.once && other.logLevel == this.logLevel && other.rootPath.equals(this.rootPath);
    }

    protected Object clone() {
        Cloneable o = null;
        try {
            o = (Cloneable)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return o;
    }

    public static class Builder {
        private static final int DEFAULT_LOG_LEVEL = LogLevel.ALL.level;
        private int logLevel;
        private String rootPath;
        private boolean enableCollectCrash;
        private boolean allowedWriteFile;
        private boolean allowedPrintConsole;
        private boolean once = false;
        private Context context;

        public Builder(Context context) {
            this.context = context;
            this.logLevel = Store.getInt(context, LogConfiguration.KEY_LOG_LEVEL, DEFAULT_LOG_LEVEL);
            this.allowedWriteFile = Store.getBoolean(context, LogConfiguration.KEY_WRITE_LOG_TO_FILE, false);
            this.allowedPrintConsole = Store.getBoolean(context, LogConfiguration.KEY_PRINT_CONSOLE, true);
            this.enableCollectCrash = Store.getBoolean(context, LogConfiguration.KEY_COLLECT_CRASH, true);
            this.rootPath = Store.getString(context, LogConfiguration.KEY_ROOT_PATH, context.getExternalFilesDir(LogConfiguration.ROOT_PATH_NAME).getAbsolutePath());
        }

        public Builder logLevel(int logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder rootPath(String rootPath) {
            this.rootPath = rootPath;
            return this;
        }

        public Builder enableCollectCrash(boolean enableCollectCrash) {
            this.enableCollectCrash = enableCollectCrash;
            return this;
        }

        public Builder allowedWriteFile(boolean allowedWriteFile) {
            this.allowedWriteFile = allowedWriteFile;
            return this;
        }

        public Builder allowedPrintConsole(boolean allowedPrintConsole) {
            this.allowedPrintConsole = allowedPrintConsole;
            return this;
        }

        public Builder once(boolean once) {
            this.once = once;
            return this;
        }

        public LogConfiguration build() {
            return new LogConfiguration(this);
        }
    }
}

