/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log;

public enum LogLevel {
    VERBOSE(2, "Verbose", "V"),
    DEBUG(3, "Debug", "D"),
    INFO(4, "Info", "I"),
    WARN(5, "Warn", "W"),
    ERROR(6, "Error", "E"),
    ALL(Integer.MIN_VALUE, "All", "A"),
    NONE(Integer.MAX_VALUE, "None", "N");

    int level;
    String desc;
    private String shortDesc;

    private LogLevel(int level, String desc, String shortDesc) {
        this.level = level;
        this.desc = desc;
        this.shortDesc = shortDesc;
    }

    public int getLevel() {
        return this.level;
    }

    public String getDesc() {
        return this.desc;
    }

    public static String getShortLevelName(int level) {
        for (LogLevel logLevel : LogLevel.values()) {
            if (logLevel.level != level) continue;
            return logLevel.shortDesc;
        }
        return "";
    }

    public static String getLevelName(int level) {
        return LogLevel.getShortLevelName(level);
    }
}

