/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log;

import com.xdja.log.ILog;
import com.xdja.log.ILogger;
import com.xdja.log.LogConfiguration;
import com.xdja.log.LogLevel;
import com.xdja.log.internal.DefaultsFactory;
import com.xdja.log.printer.AndroidPrinter;
import com.xdja.log.printer.Printer;
import com.xdja.log.printer.PrinterSet;
import com.xdja.log.printer.file.FilePrinter;
import java.io.File;
import java.util.ArrayList;

class Logger
implements ILogger,
ILog {
    private Printer printer;
    private LogConfiguration logConfiguration;
    private String logPath;

    public Logger(LogConfiguration logConfiguration) {
        this.updateConfigLog(logConfiguration);
    }

    @Override
    public void i(String tag, String message) {
        this.println(LogLevel.INFO.level, tag, message);
    }

    @Override
    public void d(String tag, String message) {
        this.println(LogLevel.DEBUG.level, tag, message);
    }

    @Override
    public void e(String tag, String message) {
        this.println(LogLevel.ERROR.level, tag, message);
    }

    @Override
    public void v(String tag, String message) {
        this.println(LogLevel.VERBOSE.level, tag, message);
    }

    @Override
    public void w(String tag, String message) {
        this.println(LogLevel.WARN.level, tag, message);
    }

    private void println(int logLevel, String tag, String message) {
        if (logLevel < this.logConfiguration.logLevel) {
            return;
        }
        this.printer.println(logLevel, tag, message);
    }

    @Override
    public void updateConfigLog(LogConfiguration configuration) {
        this.logConfiguration = configuration;
        this.logPath = new File(this.logConfiguration.rootPath, "normal").getAbsolutePath();
        ArrayList<Printer> printerList = new ArrayList<Printer>();
        if (this.logConfiguration.allowedPrintConsole) {
            printerList.add(new AndroidPrinter());
        }
        if (this.logConfiguration.allowedWriteFile) {
            printerList.add(new FilePrinter.Builder(this.logPath).fileNameGenerator(DefaultsFactory.createFileNameGenerator()).backupStrategy(DefaultsFactory.createBackupStrategy()).cleanStrategy(DefaultsFactory.createCleanStrategy()).build());
        }
        this.printer = new PrinterSet(printerList);
    }

    @Override
    public String getLogPath() {
        return this.logPath;
    }
}

