/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log;

import com.xdja.log.ILog;
import com.xdja.log.LogConfiguration;
import com.xdja.log.XdjaLog;
import com.xdja.log.crash.CrashLogger;
import com.xdja.log.internal.DefaultsFactory;
import com.xdja.log.printer.Printer;
import com.xdja.log.printer.PrinterSet;
import com.xdja.log.printer.file.FilePrinter;
import java.io.File;
import java.util.ArrayList;

class XdjaCrashLog
implements ILog {
    private static final String TAG = "XdjaCrashLog";
    private Printer printer;
    private String crashLogPath;

    public XdjaCrashLog(LogConfiguration configuration) {
        this.updateConfigLog(configuration);
    }

    @Override
    public void updateConfigLog(LogConfiguration configuration) {
        if (configuration == null) {
            XdjaLog.e(TAG, "crash log config is empty");
            return;
        }
        this.crashLogPath = new File(configuration.rootPath, "crash").getAbsolutePath();
        if (configuration.enableCollectCrash) {
            ArrayList<Printer> printerList = new ArrayList<Printer>();
            printerList.add(new FilePrinter.Builder(this.crashLogPath).keepOpen(false).useWork(false).fileNameGenerator(DefaultsFactory.createFileNameGenerator()).backupStrategy(DefaultsFactory.createBackupStrategy()).cleanStrategy(DefaultsFactory.createCleanStrategy()).build());
            this.printer = new PrinterSet(printerList);
            this.openCrashLog();
        } else {
            this.printer = null;
            CrashLogger.getInstance().closeCrashLog();
            XdjaLog.d(TAG, "disable collect crash");
        }
    }

    @Override
    public String getLogPath() {
        return this.crashLogPath;
    }

    public void openCrashLog() {
        if (this.printer != null) {
            CrashLogger.getInstance().openCrashLog(this.printer);
        }
    }
}

