/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log;

import android.content.Context;
import android.util.Log;
import com.xdja.log.LogConfiguration;
import com.xdja.log.Logger;
import com.xdja.log.XdjaCrashLog;
import com.xdja.log.XdjaLogZip;
import com.xdja.log.XdjaLogcat;
import java.io.File;

public class XdjaLog {
    static LogConfiguration sLogConfiguration;
    static Logger logger;
    static XdjaLogcat xdjaLogCat;
    static XdjaCrashLog xdjaCrashLog;
    static boolean initFlag;

    public static void init(Context context) {
        if (context == null) {
            throw new NullPointerException("content is empty");
        }
        XdjaLog.init(new LogConfiguration.Builder(context).build());
    }

    public static void init(LogConfiguration configuration) {
        if (initFlag) {
            return;
        }
        initFlag = true;
        if (configuration == null) {
            throw new NullPointerException("LogConfiguration is empty");
        }
        sLogConfiguration = configuration;
        xdjaCrashLog = new XdjaCrashLog(sLogConfiguration);
        logger = new Logger(sLogConfiguration);
        xdjaLogCat = new XdjaLogcat(sLogConfiguration);
        XdjaLog.updateLogConfiguration(configuration);
    }

    public static LogConfiguration getCurLogConfiguration() {
        if (!initFlag) {
            return null;
        }
        return (LogConfiguration)sLogConfiguration.clone();
    }

    public static boolean updateLogConfiguration(LogConfiguration configuration) {
        if (!initFlag) {
            return false;
        }
        if (configuration == null) {
            throw new NullPointerException("LogConfiguration is empty");
        }
        if (!configuration.equals(sLogConfiguration)) {
            sLogConfiguration = configuration;
            if (!XdjaLog.sLogConfiguration.once) {
                sLogConfiguration.store();
            }
            logger.updateConfigLog(configuration);
            xdjaCrashLog.updateConfigLog(configuration);
            xdjaLogCat.updateConfigLog(configuration);
        }
        return true;
    }

    public static String getPathForWriteLog() {
        if (!initFlag) {
            return null;
        }
        return XdjaLog.sLogConfiguration.rootPath;
    }

    public static void startLogCatOutput() {
        if (!initFlag) {
            return;
        }
        xdjaLogCat.startLogCatOutput();
    }

    public static void stopLogCatOutput() {
        if (!initFlag) {
            return;
        }
        xdjaLogCat.stopLogCatOutput();
    }

    public static File zipAllLog() {
        return XdjaLogZip.zipAllLog();
    }

    public static void v(String tag, String message) {
        if (!XdjaLog.isInit()) {
            Log.v((String)tag, (String)message);
            return;
        }
        logger.v(tag, message);
    }

    public static void d(String tag, String message) {
        if (!XdjaLog.isInit()) {
            Log.d((String)tag, (String)message);
            return;
        }
        logger.d(tag, message);
    }

    public static void i(String tag, String message) {
        if (!XdjaLog.isInit()) {
            Log.i((String)tag, (String)message);
            return;
        }
        logger.i(tag, message);
    }

    public static void w(String tag, String message) {
        if (!XdjaLog.isInit()) {
            Log.w((String)tag, (String)message);
            return;
        }
        logger.w(tag, message);
    }

    public static void e(String tag, String message) {
        if (!XdjaLog.isInit()) {
            Log.e((String)tag, (String)message);
            return;
        }
        logger.e(tag, message);
    }

    private static boolean isInit() {
        return initFlag;
    }

    static {
        initFlag = false;
    }
}

