/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log;

import com.xdja.log.LogConfiguration;
import com.xdja.log.XdjaLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

class XdjaLogZip {
    XdjaLogZip() {
    }

    public static File zipAllLog() {
        LogConfiguration curLogConfiguration = XdjaLog.getCurLogConfiguration();
        if (curLogConfiguration == null) {
            throw new RuntimeException("XdjaLog is not init()!");
        }
        String rootPath = curLogConfiguration.rootPath;
        String time = XdjaLogZip.getTimeStr("yyyy-MM-dd hh:mm:ss");
        File zipFile = new File(rootPath, time + ".zip");
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(zipFile));
            ArrayList<File> compressFileList = new ArrayList<File>();
            File[] files = new File(rootPath).listFiles();
            if (files == null) {
                File file = null;
                return file;
            }
            for (File sourceFile : files) {
                if (sourceFile.isFile()) continue;
                XdjaLogZip.compress(sourceFile, zos, sourceFile.getName(), compressFileList);
            }
            XdjaLogZip.deleteCompressFile(compressFileList);
        }
        catch (Exception e) {
            throw new RuntimeException("zip error from ZipUtils", e);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return zipFile;
    }

    private static void compress(File sourceFile, ZipOutputStream zos, String name, List<File> compressFileList) throws Exception {
        byte[] buf = new byte[4096];
        if (sourceFile.isFile()) {
            int len;
            zos.putNextEntry(new ZipEntry(name));
            FileInputStream in = new FileInputStream(sourceFile);
            while ((len = in.read(buf)) != -1) {
                zos.write(buf, 0, len);
            }
            zos.closeEntry();
            in.close();
            compressFileList.add(sourceFile);
        } else {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                zos.putNextEntry(new ZipEntry(name + "/"));
                zos.closeEntry();
            } else {
                for (File file : listFiles) {
                    XdjaLogZip.compress(file, zos, name + "/" + file.getName(), compressFileList);
                }
            }
        }
    }

    private static void deleteCompressFile(List<File> list) {
        for (File file : list) {
            File renameFile;
            if (!file.renameTo(renameFile = new File(file.getAbsolutePath() + "_logtmp"))) continue;
            renameFile.delete();
        }
    }

    private static String getTimeStr(String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat, Locale.CHINA);
        sdf.setTimeZone(TimeZone.getDefault());
        String time = sdf.format(new Date(System.currentTimeMillis()));
        return time;
    }
}

