/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log;

import com.xdja.log.ILog;
import com.xdja.log.LogConfiguration;
import com.xdja.log.XdjaLog;
import com.xdja.log.internal.DefaultsFactory;
import com.xdja.log.logcat.LogcatFileOutput;
import com.xdja.log.logcat.LogcatLogger;
import com.xdja.log.printer.file.naming.LogcatFileNameGenerator;
import java.io.File;

class XdjaLogcat
implements ILog {
    private static final String TAG = "XdjaLogCat";
    private String logCatPath;
    private LogcatFileOutput logcatFileOutput;

    public XdjaLogcat(LogConfiguration configuration) {
        this.updateConfigLog(configuration);
    }

    @Override
    public void updateConfigLog(LogConfiguration configuration) {
        this.logCatPath = new File(configuration.rootPath, "logcat").getAbsolutePath();
        this.logcatFileOutput = new LogcatFileOutput.Builder(this.logCatPath).backupStrategy(DefaultsFactory.createBackupStrategy()).cleanStrategy(DefaultsFactory.createCleanStrategy()).fileNameGenerator(new LogcatFileNameGenerator()).build();
    }

    @Override
    public String getLogPath() {
        return this.logCatPath;
    }

    public boolean startLogCatOutput() {
        if (this.logcatFileOutput != null) {
            XdjaLog.e(TAG, "start logcat output");
            return LogcatLogger.getInstance().startLogCatOutput(this.logcatFileOutput);
        }
        XdjaLog.e(TAG, "logcat output printer is empty");
        return false;
    }

    public void stopLogCatOutput() {
        XdjaLog.e(TAG, "stop logcat output");
        LogcatLogger.getInstance().stopLogCatOutput();
    }
}

