/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.crash;

import android.os.Process;
import android.util.Log;
import com.xdja.log.LogLevel;
import com.xdja.log.printer.Printer;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class CrashLogger
implements Thread.UncaughtExceptionHandler {
    private static final String TAG = "CrashLog";
    private Printer mPrinter;

    public void openCrashLog(Printer printer) {
        if (this.mPrinter != null) {
            this.mPrinter.stopPrint();
        }
        this.mPrinter = printer;
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    public void closeCrashLog() {
        if (this.mPrinter != null) {
            this.mPrinter.stopPrint();
            this.mPrinter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        PrintWriter printWriter = null;
        Writer writer = null;
        try {
            StringBuffer msg = new StringBuffer();
            msg.append("\n");
            writer = new StringWriter();
            printWriter = new PrintWriter(writer);
            throwable.printStackTrace(printWriter);
            msg.append(writer.toString());
            this.println(LogLevel.ERROR.getLevel(), LogLevel.ERROR.getDesc(), msg.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Process.killProcess((int)Process.myPid());
        }
    }

    private void println(int logLevel, String tag, String message) {
        if (this.mPrinter != null) {
            this.mPrinter.println(logLevel, tag, message);
        }
        Log.e((String)TAG, (String)message);
    }

    public static CrashLogger getInstance() {
        return CrashLoggerHolder.INSTANCE;
    }

    private CrashLogger() {
    }

    static class CrashLoggerHolder {
        static CrashLogger INSTANCE = new CrashLogger();

        CrashLoggerHolder() {
        }
    }
}

