/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.logcat;

import com.xdja.log.LogLevel;
import com.xdja.log.internal.DefaultsFactory;
import com.xdja.log.printer.file.backup.BackupStrategy;
import com.xdja.log.printer.file.clean.CleanStrategy;
import com.xdja.log.printer.file.naming.FileNameGenerator;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class LogcatFileOutput {
    private String folderPath;
    private FileNameGenerator fileNameGenerator;
    BackupStrategy backupStrategy;
    CleanStrategy cleanStrategy;
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.CHINA);

    public LogcatFileOutput(Builder builder) {
        this.folderPath = builder.folderPath;
        this.fileNameGenerator = builder.fileNameGenerator;
        this.backupStrategy = builder.backupStrategy;
        this.cleanStrategy = builder.cleanStrategy;
        this.checkLogFolder();
    }

    private void checkLogFolder() {
        File folder = new File(this.folderPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    public void logcatFileOperation(ILogcatEvent iLogcatEvent) {
        this.cleanLogFilesIfNecessary();
        File targetFile = this.getCurrentLogcatPath();
        if (this.backupStrategy.shouldBackup(targetFile)) {
            iLogcatEvent.close();
            File backupFile = new File(this.folderPath, this.backupName());
            if (backupFile.exists()) {
                backupFile.delete();
            }
            targetFile.renameTo(backupFile);
            iLogcatEvent.open();
        }
    }

    private String backupName() {
        this.sdf.setTimeZone(TimeZone.getDefault());
        return this.sdf.format(new Date(System.currentTimeMillis())) + ".bak";
    }

    private void cleanLogFilesIfNecessary() {
        File logDir = new File(this.folderPath);
        File[] files = logDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!this.cleanStrategy.shouldClean(file)) continue;
            file.delete();
        }
    }

    public File getCurrentLogcatPath() {
        return new File(this.folderPath, this.fileNameGenerator.generateFileName(LogLevel.ERROR.getLevel(), System.currentTimeMillis()));
    }

    public static interface ILogcatEvent {
        public void open();

        public void close();
    }

    public static class Builder {
        String folderPath;
        FileNameGenerator fileNameGenerator;
        BackupStrategy backupStrategy;
        CleanStrategy cleanStrategy;

        public Builder(String folderPath) {
            this.folderPath = folderPath;
        }

        public Builder fileNameGenerator(FileNameGenerator fileNameGenerator) {
            this.fileNameGenerator = fileNameGenerator;
            return this;
        }

        public Builder backupStrategy(BackupStrategy backupStrategy) {
            this.backupStrategy = backupStrategy;
            return this;
        }

        public Builder cleanStrategy(CleanStrategy cleanStrategy) {
            this.cleanStrategy = cleanStrategy;
            return this;
        }

        public LogcatFileOutput build() {
            this.fillEmptyFields();
            return new LogcatFileOutput(this);
        }

        private void fillEmptyFields() {
            if (this.fileNameGenerator == null) {
                this.fileNameGenerator = DefaultsFactory.createFileNameGenerator();
            }
            if (this.backupStrategy == null) {
                this.backupStrategy = DefaultsFactory.createBackupStrategy();
            }
            if (this.cleanStrategy == null) {
                this.cleanStrategy = DefaultsFactory.createCleanStrategy();
            }
        }
    }
}

