/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.logcat;

import android.os.SystemClock;
import com.xdja.log.XdjaLog;
import com.xdja.log.logcat.LogcatFileOutput;
import java.io.IOException;

public class LogcatLogger {
    private static final String THIS_FILE = "LogcatLogger";
    private boolean running = false;
    private static Process process = null;
    private boolean threadEnd = true;

    public synchronized boolean startLogCatOutput(final LogcatFileOutput logcatFileOutput) {
        if (this.running) {
            XdjaLog.d(THIS_FILE, "Loggcat capture is already running");
            return true;
        }
        if (logcatFileOutput == null) {
            XdjaLog.d(THIS_FILE, "Loggcat file config is empty");
            return false;
        }
        final String logPath = logcatFileOutput.getCurrentLogcatPath().getAbsolutePath();
        boolean success = this.startCapture(logPath);
        if (!success) {
            XdjaLog.e(THIS_FILE, "Error to start capture logcat!");
            return false;
        }
        if (this.threadEnd) {
            XdjaLog.d(THIS_FILE, "start logcat thread");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    LogcatLogger.this.threadEnd = false;
                    while (LogcatLogger.this.running) {
                        logcatFileOutput.logcatFileOperation(new LogcatFileOutput.ILogcatEvent(){

                            @Override
                            public void open() {
                                LogcatLogger.this.startCapture(logPath);
                            }

                            @Override
                            public void close() {
                                LogcatLogger.this.stopCapture();
                            }
                        });
                        if (!LogcatLogger.this.logcatProcessIsAlive()) {
                            XdjaLog.e(LogcatLogger.THIS_FILE, "Logcat thread died!!!");
                            LogcatLogger.this.startCapture(logPath);
                        }
                        SystemClock.sleep((long)1000L);
                    }
                    LogcatLogger.this.threadEnd = true;
                }
            }).start();
        }
        this.running = true;
        return true;
    }

    private boolean logcatProcessIsAlive() {
        boolean isAlive = false;
        try {
            int exitValue = process.exitValue();
            if (exitValue != 0) {
                isAlive = false;
            }
        }
        catch (IllegalThreadStateException e) {
            e.printStackTrace();
            isAlive = true;
        }
        return isAlive;
    }

    private boolean startCapture(String logPath) {
        try {
            this.stopCapture();
            process = Runtime.getRuntime().exec("logcat -c");
            process = Runtime.getRuntime().exec("logcat -f " + logPath);
        }
        catch (IOException e) {
            XdjaLog.e(THIS_FILE, "Trye to capture app logcat failed. IO exception");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void stopCapture() {
        if (process != null) {
            process.destroy();
        }
    }

    public void stopLogCatOutput() {
        this.stopCapture();
        this.running = false;
    }

    public static LogcatLogger getInstance() {
        return LogcatLoggerHolder.INSTANCE;
    }

    private LogcatLogger() {
    }

    static class LogcatLoggerHolder {
        static LogcatLogger INSTANCE = new LogcatLogger();

        LogcatLoggerHolder() {
        }
    }
}

