/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.printer;

import android.util.Log;
import com.xdja.log.printer.Printer;

public class AndroidPrinter
implements Printer {
    static final int DEFAULT_MAX_CHUNK_SIZE = 4000;
    private boolean autoSeparate;
    private int maxChunkSize;

    public AndroidPrinter() {
        this(false, 4000);
    }

    public AndroidPrinter(boolean autoSeparate) {
        this(autoSeparate, 4000);
    }

    public AndroidPrinter(int maxChunkSize) {
        this(false, maxChunkSize);
    }

    public AndroidPrinter(boolean autoSeparate, int maxChunkSize) {
        this.autoSeparate = autoSeparate;
        this.maxChunkSize = maxChunkSize;
    }

    @Override
    public void println(int logLevel, String tag, String msg) {
        int msgLength = msg.length();
        int start = 0;
        while (start < msgLength) {
            int newLine;
            if (msg.charAt(start) == '\n') {
                ++start;
                continue;
            }
            int end = Math.min(start + this.maxChunkSize, msgLength);
            end = this.autoSeparate ? ((newLine = msg.indexOf(10, start)) != -1 ? newLine : end) : AndroidPrinter.adjustEnd(msg, start, end);
            this.printChunk(logLevel, tag, msg.substring(start, end));
            start = end;
        }
    }

    @Override
    public void stopPrint() {
    }

    static int adjustEnd(String msg, int start, int originEnd) {
        if (originEnd == msg.length()) {
            return originEnd;
        }
        if (msg.charAt(originEnd) == '\n') {
            return originEnd;
        }
        for (int last = originEnd - 1; start < last; --last) {
            if (msg.charAt(last) != '\n') continue;
            return last;
        }
        return originEnd;
    }

    void printChunk(int logLevel, String tag, String msg) {
        Log.println((int)logLevel, (String)tag, (String)msg);
    }
}

