/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.printer.file;

import com.xdja.log.flattener.Flattener2;
import com.xdja.log.internal.DefaultsFactory;
import com.xdja.log.printer.Printer;
import com.xdja.log.printer.file.backup.BackupStrategy;
import com.xdja.log.printer.file.clean.CleanStrategy;
import com.xdja.log.printer.file.naming.FileNameGenerator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class FilePrinter
implements Printer {
    private boolean useWork = true;
    private boolean keepOpen;
    private final String folderPath;
    private final FileNameGenerator fileNameGenerator;
    private final BackupStrategy backupStrategy;
    private final CleanStrategy cleanStrategy;
    private Flattener2 flattener;
    private Writer writer;
    private volatile Worker worker;
    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm", Locale.CHINA);

    FilePrinter(Builder builder) {
        this.folderPath = builder.folderPath;
        this.fileNameGenerator = builder.fileNameGenerator;
        this.backupStrategy = builder.backupStrategy;
        this.cleanStrategy = builder.cleanStrategy;
        this.flattener = builder.flattener;
        this.useWork = builder.useWork;
        this.keepOpen = builder.keepOpen;
        this.writer = new Writer();
        if (this.useWork) {
            this.worker = new Worker();
        }
        this.checkLogFolder();
    }

    private void checkLogFolder() {
        File folder = new File(this.folderPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    @Override
    public void println(int logLevel, String tag, String msg) {
        long timeMillis = System.currentTimeMillis();
        if (this.useWork) {
            if (!this.worker.isStarted()) {
                this.worker.start();
            }
            this.worker.enqueue(new LogItem(timeMillis, logLevel, tag, msg));
        } else {
            this.doPrintln(timeMillis, logLevel, tag, msg);
        }
    }

    @Override
    public void stopPrint() {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    private void doPrintln(long timeMillis, int logLevel, String tag, String msg) {
        File lastFile;
        boolean isWriterClosed;
        String lastFileName = this.writer.getLastFileName();
        boolean bl = isWriterClosed = !this.writer.isOpened();
        if (lastFileName == null || isWriterClosed || this.fileNameGenerator.isFileNameChangeable()) {
            String newFileName = this.fileNameGenerator.generateFileName(logLevel, System.currentTimeMillis());
            if (newFileName == null || newFileName.trim().length() == 0) {
                throw new IllegalArgumentException("File name should not be empty.");
            }
            if (!newFileName.equals(lastFileName) || isWriterClosed) {
                this.writer.close();
                this.cleanLogFilesIfNecessary();
                if (!this.writer.open(newFileName)) {
                    return;
                }
                lastFileName = newFileName;
            }
        }
        if (this.backupStrategy.shouldBackup(lastFile = this.writer.getFile())) {
            this.writer.close();
            File backupFile = new File(this.folderPath, this.backupName(lastFile));
            if (backupFile.exists()) {
                backupFile.delete();
            }
            lastFile.renameTo(backupFile);
            if (!this.writer.open(lastFileName)) {
                return;
            }
        }
        String flattenedLog = this.flattener.flatten(timeMillis, logLevel, tag, msg).toString();
        this.writer.appendLog(flattenedLog);
        if (!this.keepOpen) {
            this.writer.close();
        }
    }

    private String backupName(File srcFile) {
        this.sdf.setTimeZone(TimeZone.getDefault());
        return srcFile.getName() + " " + this.sdf.format(new Date(System.currentTimeMillis())) + ".bak";
    }

    private void cleanLogFilesIfNecessary() {
        File logDir = new File(this.folderPath);
        File[] files = logDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!this.cleanStrategy.shouldClean(file)) continue;
            file.delete();
        }
    }

    private class Writer {
        private String lastFileName;
        private File logFile;
        private BufferedWriter bufferedWriter;

        private Writer() {
        }

        boolean isOpened() {
            return this.bufferedWriter != null && this.logFile.exists();
        }

        String getLastFileName() {
            return this.lastFileName;
        }

        File getFile() {
            return this.logFile;
        }

        boolean open(String newFileName) {
            this.lastFileName = newFileName;
            this.logFile = new File(FilePrinter.this.folderPath, newFileName);
            if (!this.logFile.exists()) {
                try {
                    File parent = this.logFile.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    this.logFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.close();
                    return false;
                }
            }
            try {
                this.bufferedWriter = new BufferedWriter(new FileWriter(this.logFile, true));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close();
                return false;
            }
            return true;
        }

        boolean close() {
            if (this.bufferedWriter != null) {
                try {
                    this.bufferedWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.bufferedWriter = null;
            this.lastFileName = null;
            this.logFile = null;
            return true;
        }

        void appendLog(String flattenedLog) {
            try {
                this.bufferedWriter.write(flattenedLog);
                this.bufferedWriter.newLine();
                this.bufferedWriter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class Worker
    implements Runnable {
        private BlockingQueue<LogItem> logs = new LinkedBlockingQueue<LogItem>();
        private volatile boolean started;

        private Worker() {
        }

        void enqueue(LogItem log) {
            try {
                this.logs.put(log);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isStarted() {
            Worker worker = this;
            synchronized (worker) {
                return this.started;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void start() {
            Worker worker = this;
            synchronized (worker) {
                if (this.started) {
                    return;
                }
                new Thread(this).start();
                this.started = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LogItem log;
                while ((log = this.logs.take()) != null) {
                    FilePrinter.this.doPrintln(log.timeMillis, log.level, log.tag, log.msg);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Worker worker = this;
                synchronized (worker) {
                    this.started = false;
                }
            }
        }
    }

    private static class LogItem {
        long timeMillis;
        int level;
        String tag;
        String msg;

        LogItem(long timeMillis, int level, String tag, String msg) {
            this.timeMillis = timeMillis;
            this.level = level;
            this.tag = tag;
            this.msg = msg;
        }
    }

    public static class Builder {
        boolean keepOpen = true;
        String folderPath;
        FileNameGenerator fileNameGenerator;
        BackupStrategy backupStrategy;
        CleanStrategy cleanStrategy;
        Flattener2 flattener;
        boolean useWork = true;

        public Builder(String folderPath) {
            this.folderPath = folderPath;
        }

        public Builder keepOpen(boolean keepOpen) {
            this.keepOpen = keepOpen;
            return this;
        }

        public Builder useWork(boolean useWork) {
            this.useWork = useWork;
            return this;
        }

        public Builder fileNameGenerator(FileNameGenerator fileNameGenerator) {
            this.fileNameGenerator = fileNameGenerator;
            return this;
        }

        public Builder backupStrategy(BackupStrategy backupStrategy) {
            this.backupStrategy = backupStrategy;
            return this;
        }

        public Builder cleanStrategy(CleanStrategy cleanStrategy) {
            this.cleanStrategy = cleanStrategy;
            return this;
        }

        public Builder flattener(Flattener2 flattener) {
            this.flattener = flattener;
            return this;
        }

        public FilePrinter build() {
            this.fillEmptyFields();
            return new FilePrinter(this);
        }

        private void fillEmptyFields() {
            if (this.fileNameGenerator == null) {
                this.fileNameGenerator = DefaultsFactory.createFileNameGenerator();
            }
            if (this.backupStrategy == null) {
                this.backupStrategy = DefaultsFactory.createBackupStrategy();
            }
            if (this.cleanStrategy == null) {
                this.cleanStrategy = DefaultsFactory.createCleanStrategy();
            }
            if (this.flattener == null) {
                this.flattener = DefaultsFactory.createFlattener2();
            }
        }
    }
}

