/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.compiler;

import com.xdja.compiler.AnnotationVisitor;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

public class AnnotationUtil {
    public static Object getAnnotationValue(Element element, Class<? extends Annotation> annotationType, String parameterName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationType.getName().equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!entry.getKey().getSimpleName().toString().equals(parameterName)) continue;
                return entry.getValue().accept(new AnnotationVisitor(), null);
            }
        }
        return null;
    }

    @SafeVarargs
    public static boolean containsAnyAnnotation(Element element, Class<? extends Annotation> ... annotationTypes) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            for (Class<? extends Annotation> annotationType : annotationTypes) {
                if (annotationType == null || !annotationType.getName().equals(annotationMirror.getAnnotationType().toString())) continue;
                return true;
            }
        }
        return false;
    }
}

