/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.base.adapter;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.xdja.baselibrary.R;
import com.xdja.baselibrary.base.adapter.BaseRecyclerViewAdapter;
import com.xdja.baselibrary.base.adapter.XViewHolder;
import java.util.List;

public abstract class XRecyclerViewAdapter<T>
extends BaseRecyclerViewAdapter<T, XViewHolder> {
    private SparseArray<View> mHeaderViews = new SparseArray();
    private SparseArray<View> mFooterViews = new SparseArray();
    private static int TYPE_HEADER = 256;
    private static int TYPE_FOOTER = 512;
    private static final int TYPE_LOAD_FAILED = 1;
    private static final int TYPE_NO_MORE = 2;
    private static final int TYPE_LOAD_MORE = 3;
    private static final int TYPE_NO_VIEW = 4;
    private RecyclerView mRecyclerView;
    private View mLoadMoreView;
    private View mLoadMoreFailedView;
    private View mNoMoreView;
    private TextView mNoMoreDataText;
    private String mNoMoreDataInfo = "\u5df2\u663e\u793a\u5168\u90e8\u5185\u5bb9";
    private int mLoadItemType = 4;
    private OnLoadMoreListener onLoadMoreListener;
    private LayoutInflater inflater;
    private int layoutId;
    private boolean isLoadError = false;
    private boolean isHaveStatesView = false;
    private OnItemClickListener onItemClickListener;
    private OnItemLongClickListener onItemLongClickListener;
    private GridLayoutManager.SpanSizeLookup mSpanSizeLookup;

    public XRecyclerViewAdapter(@NonNull RecyclerView mRecyclerView, List<T> dataLists) {
        this(mRecyclerView, dataLists, -1);
    }

    public XRecyclerViewAdapter(@NonNull RecyclerView mRecyclerView, List<T> dataLists, @LayoutRes int layoutId) {
        this.mRecyclerView = mRecyclerView;
        this.dataLists = dataLists;
        this.layoutId = layoutId;
        this.inflater = LayoutInflater.from((Context)mRecyclerView.getContext());
    }

    public int getItemViewType(int position) {
        if (this.isHeaderPosition(position)) {
            return this.mHeaderViews.keyAt(position);
        }
        if (this.isLoadPosition(position)) {
            return this.mLoadItemType;
        }
        if (this.isFooterPosition(position)) {
            position = position - this.getHeaderCount() - this.getDataCount();
            return this.mFooterViews.keyAt(position);
        }
        return this.getItemLayoutResId(this.getItem(position -= this.getHeaderCount()), position);
    }

    public XViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (this.isHeaderViewType(viewType)) {
            return new XViewHolder((View)this.mHeaderViews.get(viewType));
        }
        if (this.isFooterViewType(viewType)) {
            return new XViewHolder((View)this.mFooterViews.get(viewType));
        }
        if (viewType == 2) {
            this.mNoMoreView = this.inflater.inflate(R.layout.moments_base_view_no_more, (ViewGroup)this.mRecyclerView, false);
            this.mNoMoreDataText = (TextView)this.mNoMoreView.findViewById(R.id.tv_no_more_data);
            this.mNoMoreDataText.setText((CharSequence)this.mNoMoreDataInfo);
            return new XViewHolder(this.mNoMoreView);
        }
        if (viewType == 3) {
            this.mLoadMoreView = this.inflater.inflate(R.layout.moments_base_view_loading, (ViewGroup)this.mRecyclerView, false);
            return new XViewHolder(this.mLoadMoreView);
        }
        if (viewType == 1) {
            this.mLoadMoreFailedView = this.inflater.inflate(R.layout.moments_base_view_loading_failed, (ViewGroup)this.mRecyclerView, false);
            return new XViewHolder(this.mLoadMoreFailedView);
        }
        return new XViewHolder(this.inflater.inflate(viewType, parent, false));
    }

    public void onBindViewHolder(final XViewHolder holder, int position) {
        if (holder.getItemViewType() == 1) {
            this.mLoadMoreFailedView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (XRecyclerViewAdapter.this.onLoadMoreListener != null) {
                        XRecyclerViewAdapter.this.onLoadMoreListener.onRetry();
                        XRecyclerViewAdapter.this.isLoadMore(true);
                    }
                }
            });
            return;
        }
        if (holder.getItemViewType() == 3) {
            if (this.onLoadMoreListener != null && this.isHaveStatesView && !this.isLoadError) {
                this.onLoadMoreListener.onLoadMore();
            }
            return;
        }
        if (this.isFooterPosition(position) || this.isHeaderPosition(position)) {
            return;
        }
        final int finalPosition = position - this.getHeaderCount();
        holder.itemView.setOnClickListener(v -> {
            if (this.onItemClickListener != null) {
                this.onItemClickListener.onItemClick(holder.itemView, finalPosition);
            }
        });
        holder.itemView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (XRecyclerViewAdapter.this.onItemLongClickListener != null) {
                    return XRecyclerViewAdapter.this.onItemLongClickListener.onItemLongClick(holder.itemView, finalPosition);
                }
                return false;
            }
        });
        this.bindData(holder, this.getItem(finalPosition), finalPosition);
    }

    protected abstract void bindData(XViewHolder var1, T var2, int var3);

    public int getItemLayoutResId(T data, int position) {
        return this.layoutId;
    }

    public void setSpanSizeLookup(GridLayoutManager.SpanSizeLookup spanSizeLookup) {
        this.mSpanSizeLookup = spanSizeLookup;
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        RecyclerView.LayoutManager manager = recyclerView.getLayoutManager();
        if (manager instanceof GridLayoutManager) {
            final GridLayoutManager gridLayoutManager = (GridLayoutManager)manager;
            gridLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    if (XRecyclerViewAdapter.this.mSpanSizeLookup == null) {
                        return XRecyclerViewAdapter.this.isHeaderPosition(position) || XRecyclerViewAdapter.this.isFooterPosition(position) ? gridLayoutManager.getSpanCount() : 1;
                    }
                    return XRecyclerViewAdapter.this.isHeaderPosition(position) || XRecyclerViewAdapter.this.isFooterPosition(position) ? gridLayoutManager.getSpanCount() : XRecyclerViewAdapter.this.mSpanSizeLookup.getSpanSize(position - XRecyclerViewAdapter.this.getHeaderCount());
                }
            });
        }
    }

    public void onViewAttachedToWindow(XViewHolder holder) {
        ViewGroup.LayoutParams lp;
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        int position = holder.getLayoutPosition();
        if ((this.isFooterPosition(position) || this.isHeaderPosition(position)) && (lp = holder.itemView.getLayoutParams()) != null && lp instanceof StaggeredGridLayoutManager.LayoutParams) {
            StaggeredGridLayoutManager.LayoutParams p = (StaggeredGridLayoutManager.LayoutParams)lp;
            p.setFullSpan(true);
        }
    }

    public int getItemCount() {
        return this.getDataCount() + this.getHeaderCount() + this.getFooterCount() + (this.isHaveStatesView ? 1 : 0);
    }

    public int getDataCount() {
        return this.dataLists.size();
    }

    public int getHeaderCount() {
        return this.mHeaderViews.size();
    }

    public int getFooterCount() {
        return this.mFooterViews.size();
    }

    public void isLoadMore(boolean isHaveStatesView) {
        this.mLoadItemType = 3;
        this.isLoadError = false;
        this.isHaveStatesView = isHaveStatesView;
        this.notifyItemChanged(this.getItemCount());
    }

    public void showLoadError() {
        this.mLoadItemType = 1;
        this.isLoadError = true;
        this.isHaveStatesView = true;
        this.notifyItemChanged(this.getItemCount());
    }

    public void showLoadComplete() {
        this.mLoadItemType = 2;
        this.isLoadError = false;
        this.isHaveStatesView = true;
        this.notifyItemChanged(this.getItemCount());
    }

    public void showLoadComplete(String info) {
        this.mNoMoreDataInfo = info;
        this.mLoadItemType = 2;
        this.isLoadError = false;
        this.isHaveStatesView = true;
        this.notifyItemChanged(this.getItemCount());
    }

    public void hideLoadComplete() {
        this.mLoadItemType = 4;
        this.isLoadError = false;
        this.isHaveStatesView = false;
        this.notifyItemChanged(this.getItemCount());
    }

    @Override
    public void setDataLists(List<T> datas) {
        this.mLoadItemType = 3;
        super.setDataLists(datas);
    }

    private boolean isFooterViewType(int viewType) {
        int position = this.mFooterViews.indexOfKey(viewType);
        return position >= 0;
    }

    private boolean isHeaderViewType(int viewType) {
        int position = this.mHeaderViews.indexOfKey(viewType);
        return position >= 0;
    }

    private boolean isFooterPosition(int position) {
        return position >= this.getHeaderCount() + this.getDataCount();
    }

    private boolean isLoadPosition(int position) {
        return position == this.getItemCount() - 1 && this.isHaveStatesView;
    }

    private boolean isHeaderPosition(int position) {
        return position < this.getHeaderCount();
    }

    public void addHeaderView(View view) {
        int position = this.mHeaderViews.indexOfValue((Object)view);
        if (position < 0) {
            this.mHeaderViews.put(TYPE_HEADER++, (Object)view);
        }
        this.notifyDataSetChanged();
    }

    public void addFooterView(View view) {
        int position = this.mFooterViews.indexOfValue((Object)view);
        if (position < 0) {
            this.mFooterViews.put(TYPE_FOOTER++, (Object)view);
        }
        this.notifyDataSetChanged();
    }

    public void removeHeaderView(View view) {
        int index = this.mHeaderViews.indexOfValue((Object)view);
        if (index < 0) {
            return;
        }
        this.mHeaderViews.removeAt(index);
        this.notifyDataSetChanged();
    }

    public void removeFooterView(View view) {
        int index = this.mFooterViews.indexOfValue((Object)view);
        if (index < 0) {
            return;
        }
        this.mFooterViews.removeAt(index);
        this.notifyDataSetChanged();
    }

    public XRecyclerViewAdapter<T> setOnLoadMoreListener(OnLoadMoreListener onLoadMoreListener) {
        this.onLoadMoreListener = onLoadMoreListener;
        return this;
    }

    public XRecyclerViewAdapter<T> setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
        return this;
    }

    public XRecyclerViewAdapter<T> setOnItemLongClickListener(OnItemLongClickListener onItemLongClickListener) {
        this.onItemLongClickListener = onItemLongClickListener;
        return this;
    }

    public static interface OnItemLongClickListener {
        public boolean onItemLongClick(View var1, int var2);
    }

    public static interface OnItemClickListener {
        public void onItemClick(View var1, int var2);
    }

    public static interface OnLoadMoreListener {
        public void onRetry();

        public void onLoadMore();
    }
}

