/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.base.adapter.decoration;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import com.xdja.baselibrary.base.adapter.XRecyclerViewAdapter;

public class DividerDecoration
extends RecyclerView.ItemDecoration {
    private ColorDrawable mColorDrawable;
    private int mHeight;
    private int mPaddingLeft;
    private int mPaddingRight;
    private boolean mDrawLastItem = true;
    private boolean mDrawHeaderFooter = false;

    public DividerDecoration(int color, int height) {
        this.mColorDrawable = new ColorDrawable(color);
        this.mHeight = height;
    }

    public DividerDecoration(int color, int height, int paddingLeft, int paddingRight) {
        this.mColorDrawable = new ColorDrawable(color);
        this.mHeight = height;
        this.mPaddingLeft = paddingLeft;
        this.mPaddingRight = paddingRight;
    }

    public void setDrawLastItem(boolean mDrawLastItem) {
        this.mDrawLastItem = mDrawLastItem;
    }

    public void setDrawHeaderFooter(boolean mDrawHeaderFooter) {
        this.mDrawHeaderFooter = mDrawHeaderFooter;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        RecyclerView.LayoutManager layoutManager;
        int position = parent.getChildAdapterPosition(view);
        int orientation = 0;
        int headerCount = 0;
        int footerCount = 0;
        if (parent.getAdapter() instanceof XRecyclerViewAdapter) {
            headerCount = ((XRecyclerViewAdapter)parent.getAdapter()).getHeaderCount();
            footerCount = ((XRecyclerViewAdapter)parent.getAdapter()).getFooterCount();
        }
        if ((layoutManager = parent.getLayoutManager()) instanceof StaggeredGridLayoutManager) {
            orientation = ((StaggeredGridLayoutManager)layoutManager).getOrientation();
        } else if (layoutManager instanceof GridLayoutManager) {
            orientation = ((GridLayoutManager)layoutManager).getOrientation();
        } else if (layoutManager instanceof LinearLayoutManager) {
            orientation = ((LinearLayoutManager)layoutManager).getOrientation();
        }
        if (position >= headerCount && position < parent.getAdapter().getItemCount() - footerCount || this.mDrawHeaderFooter) {
            if (orientation == 1) {
                outRect.bottom = this.mHeight;
            } else {
                outRect.right = this.mHeight;
            }
        }
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        int end;
        int start;
        int dataCount;
        if (parent.getAdapter() == null) {
            return;
        }
        int orientation = 0;
        int headerCount = 0;
        int footerCount = 0;
        if (parent.getAdapter() instanceof XRecyclerViewAdapter) {
            headerCount = ((XRecyclerViewAdapter)parent.getAdapter()).getHeaderCount();
            footerCount = ((XRecyclerViewAdapter)parent.getAdapter()).getFooterCount();
            dataCount = ((XRecyclerViewAdapter)parent.getAdapter()).getDataCount();
        } else {
            dataCount = parent.getAdapter().getItemCount();
        }
        int dataStartPosition = headerCount;
        int dataEndPosition = headerCount + dataCount;
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            orientation = ((StaggeredGridLayoutManager)layoutManager).getOrientation();
        } else if (layoutManager instanceof GridLayoutManager) {
            orientation = ((GridLayoutManager)layoutManager).getOrientation();
        } else if (layoutManager instanceof LinearLayoutManager) {
            orientation = ((LinearLayoutManager)layoutManager).getOrientation();
        }
        if (orientation == 1) {
            start = parent.getPaddingLeft() + this.mPaddingLeft;
            end = parent.getWidth() - parent.getPaddingRight() - this.mPaddingRight;
        } else {
            start = parent.getPaddingTop() + this.mPaddingLeft;
            end = parent.getHeight() - parent.getPaddingBottom() - this.mPaddingRight;
        }
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            RecyclerView.LayoutParams params;
            View child = parent.getChildAt(i);
            int position = parent.getChildAdapterPosition(child);
            if (!(position >= dataStartPosition && position < dataEndPosition - 1 || position == dataEndPosition - 1 && this.mDrawLastItem) && (position >= dataStartPosition && position < dataEndPosition || !this.mDrawHeaderFooter)) continue;
            if (orientation == 1) {
                params = (RecyclerView.LayoutParams)child.getLayoutParams();
                int top = child.getBottom() + params.bottomMargin;
                int bottom = top + this.mHeight;
                this.mColorDrawable.setBounds(start, top, end, bottom);
                this.mColorDrawable.draw(c);
                continue;
            }
            params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int left = child.getRight() + params.rightMargin;
            int right = left + this.mHeight;
            this.mColorDrawable.setBounds(left, start, right, end);
            this.mColorDrawable.draw(c);
        }
    }
}

