/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SystemUtil {
    public static int getScreenWidth(Context context) {
        DisplayMetrics metric = new DisplayMetrics();
        WindowManager mWindowManager = (WindowManager)context.getSystemService("window");
        mWindowManager.getDefaultDisplay().getMetrics(metric);
        int width = metric.widthPixels;
        return width;
    }

    public static int getScreenHeight(Context context) {
        DisplayMetrics metric = new DisplayMetrics();
        WindowManager mWindowManager = (WindowManager)context.getSystemService("window");
        mWindowManager.getDefaultDisplay().getMetrics(metric);
        int height = metric.heightPixels;
        return height;
    }

    public static String getphoneScreenResolution(Context context) {
        return SystemUtil.getScreenWidth(context) + "*" + SystemUtil.getScreenHeight(context);
    }

    public static String getPhoneType() {
        return Build.MODEL;
    }

    public static String getPhoneVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getPhoneBrand() {
        return Build.BRAND;
    }

    public static String getPhoneIMEI(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (tm != null) {
            return tm.getDeviceId();
        }
        return "";
    }

    public static String getPhoneSN(Context context) {
        String serialNum = Build.SERIAL;
        return serialNum;
    }

    public static String getPhoneNumber(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (tm != null) {
            String phoneNumber = tm.getLine1Number();
            if (!TextUtils.isEmpty((CharSequence)phoneNumber) && phoneNumber.startsWith("+86")) {
                phoneNumber = phoneNumber.substring(3);
            }
            return phoneNumber;
        }
        return "";
    }

    public static String getPhoneServiceNum(Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (tm != null) {
            return tm.getSimOperatorName();
        }
        return "";
    }

    public static String getAppPackage(Context context) {
        return context.getPackageName();
    }

    public static String getApplicationName(Context context) {
        PackageManager packageManager = null;
        ApplicationInfo applicationInfo = null;
        try {
            packageManager = context.getApplicationContext().getPackageManager();
            applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            applicationInfo = null;
            return null;
        }
        String applicationName = (String)packageManager.getApplicationLabel(applicationInfo);
        return applicationName;
    }

    public static String getApplicationName(Context context, String pkgName) {
        PackageManager packageManager = null;
        ApplicationInfo applicationInfo = null;
        try {
            packageManager = context.getApplicationContext().getPackageManager();
            applicationInfo = packageManager.getApplicationInfo(pkgName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            applicationInfo = null;
            return null;
        }
        String applicationName = (String)packageManager.getApplicationLabel(applicationInfo);
        return applicationName;
    }

    public static String getAppVersionName(Context context) {
        if (TextUtils.isEmpty((CharSequence)SystemUtil.getAppPackage(context))) {
            return null;
        }
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(SystemUtil.getAppPackage(context), 0);
            return pi == null ? null : pi.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAppVersionName(Context context, String pkgName) {
        if (TextUtils.isEmpty((CharSequence)SystemUtil.getAppPackage(context))) {
            return null;
        }
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(pkgName, 0);
            return pi == null ? null : pi.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getAppVersionCode(Context context) {
        if (TextUtils.isEmpty((CharSequence)SystemUtil.getAppPackage(context))) {
            return 0;
        }
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(SystemUtil.getAppPackage(context), 0);
            return pi == null ? 0 : pi.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int getAppVersionCode(Context context, String pkgName) {
        if (TextUtils.isEmpty((CharSequence)SystemUtil.getAppPackage(context))) {
            return 0;
        }
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(pkgName, 0);
            return pi == null ? 0 : pi.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static long getAppFirstInstallTime(Context context) {
        if (TextUtils.isEmpty((CharSequence)SystemUtil.getAppPackage(context))) {
            return 0L;
        }
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(SystemUtil.getAppPackage(context), 0);
            return pi == null ? null : Long.valueOf(pi.firstInstallTime);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static long getAppFirstInstallTime(Context context, String pkgName) {
        if (TextUtils.isEmpty((CharSequence)SystemUtil.getAppPackage(context))) {
            return 0L;
        }
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(pkgName, 0);
            return pi == null ? null : Long.valueOf(pi.firstInstallTime);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static boolean isMobile(String str) {
        Pattern p = null;
        Matcher m = null;
        boolean b = false;
        p = Pattern.compile("^[1][3,4,5,7,8][0-9]{9}$");
        m = p.matcher(str);
        b = m.matches();
        return b;
    }

    public static boolean hasInstalled(Context context, String pkgName) {
        if (TextUtils.isEmpty((CharSequence)pkgName)) {
            return false;
        }
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(pkgName, 0);
            return true;
        }
        catch (PackageManager.NameNotFoundException | NullPointerException e) {
            e.printStackTrace();
            return false;
        }
    }
}

