/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.util.swipefinsh.helper;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;

public class ShadowView
extends View {
    private final float density;
    private final Paint mShadowBarPaint;
    private int mLinearShaderWidth;
    private int mShadowColor;
    private boolean isShowShadowBar;
    private int[] colors = new int[11];
    private float[] positions = new float[11];

    public ShadowView(Context context) {
        this(context, true, true);
    }

    public ShadowView(Context context, boolean showShadowBar, boolean showBackground) {
        super(context);
        this.density = context.getResources().getDisplayMetrics().density;
        this.mShadowBarPaint = new Paint();
        this.mShadowBarPaint.setDither(true);
        this.mShadowBarPaint.setAntiAlias(true);
        this.mShadowBarPaint.setSubpixelText(true);
        this.setShowColor(-16777216, showShadowBar, showBackground);
    }

    public void setShadowVisiable(boolean showShadowBar, boolean showBackground) {
        this.setShowColor(this.mShadowColor, showShadowBar, showBackground);
    }

    public void setShowColor(int shadowColor, boolean showShadowBar, boolean showBackground) {
        this.mShadowColor = shadowColor | 0xFF000000;
        this.isShowShadowBar = showShadowBar;
        if (this.isShowShadowBar) {
            for (int i = 0; i < this.colors.length; ++i) {
                float position;
                int alpha = this.getShadowAlpha((float)i * 0.1f);
                this.colors[i] = this.mShadowColor & (alpha << 24 | 0xFFFFFF);
                this.positions[i] = position = this.getShadowPosition(alpha);
            }
        }
        ColorDrawable background = showBackground ? new ColorDrawable(this.mShadowColor & 0x66FFFFFF) : null;
        this.setBackground((Drawable)background);
    }

    private float getShadowPosition(int alpha) {
        float radius = 1.25f;
        double squarePosition = (double)(radius * radius) - Math.pow(radius - (float)alpha / 255.0f, 2.0);
        if (squarePosition <= 0.0) {
            return 0.0f;
        }
        if (squarePosition >= 1.0) {
            return 1.0f;
        }
        return (float)Math.sqrt(squarePosition);
    }

    private int getShadowAlpha(float ratio) {
        float radius = 1.25f;
        double alphaF = (double)radius - Math.sqrt(radius * radius - ratio * ratio);
        int alphaI = (int)(alphaF * 255.0 + 0.5);
        if (alphaI <= 0) {
            return 0;
        }
        if (alphaI >= 255) {
            return 255;
        }
        return alphaI;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.getWidth() != this.mLinearShaderWidth) {
            this.mLinearShaderWidth = this.getWidth();
            LinearGradient linearShader = new LinearGradient((float)this.mLinearShaderWidth - this.density * 22.0f, 0.0f, (float)this.mLinearShaderWidth, 0.0f, this.colors, this.positions, Shader.TileMode.CLAMP);
            this.mShadowBarPaint.setShader((Shader)linearShader);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isShowShadowBar) {
            canvas.save();
            canvas.clipRect((float)this.getRight() - this.density * 22.0f, (float)this.getTop(), (float)this.getRight(), (float)this.getBottom());
            canvas.drawPaint(this.mShadowBarPaint);
            canvas.restore();
        }
    }
}

