/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.animation.LinearInterpolator;

@TargetApi(value=11)
public class MaMDownloading
extends View {
    private static final String TAG = "CoolDownloading";
    private int vWidth;
    private int vHeight;
    private Point center;
    private Point lineCenter;
    private final double sin45 = Math.sin(0.7853981633974483);
    private Context context;
    private Paint outPaint;
    private Paint innerPaint;
    private Paint circlePaint;
    private Point startP;
    private Point stopPL;
    private Point stopPR;
    private Point ctrlL1;
    private Point ctrlL2;
    private Point ctrlR1;
    private Point ctrlR2;
    private float ctrlWRate = 1.35f;
    private float ctrlHRate = 1.0f;
    private Path pathLeft;
    private Path pathRight;
    private Path linePath;
    private Path cornerRectPath;
    private Path progressRectPath;
    private ValueAnimator scaleAnim;
    private ValueAnimator circleToLinePathAnim;
    private ValueAnimator lineJumpAnim;
    private ValueAnimator arrowToRectAnim;
    private ValueAnimator mergeAnim;
    private final int SCALE = 4649;
    private final int CIRCLE_TO_LINE = 4913;
    private final int LINE_JUMP = 4914;
    private final int SHOW_LOADINGBAR = 4915;
    private int nowDrawState = 4649;
    private boolean JUMP_HIGHEST = false;
    private float jumpHightY;
    private float distance;
    private float circleRadius;
    private int circlePaintAlpha = 255;
    private int circleColor = Color.parseColor((String)"#0099CC");
    private int arrowColor = Color.parseColor((String)"#33CC99");
    private int progress = 0;
    private boolean isDownloading = false;
    private float barHeight = 5.0f;
    Point arrowP0;
    Point arrowP1;
    Point arrowP2;
    Point arrowP3;
    Point arrowP4;
    Point arrowP5;
    Point arrowP6;
    private float rate1 = 0.27f;
    private float rate2 = 0.55f;
    private float rate3 = 2.0f * this.rate1;
    private Point arrowCenter;
    private ValueAnimator.AnimatorUpdateListener scaleListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            float value = ((Float)animation.getAnimatedValue()).floatValue();
            MaMDownloading.this.ctrlWRate = value * 1.35f;
            MaMDownloading.this.ctrlHRate = value;
            MaMDownloading.this.rate1 = 0.27f * value;
            MaMDownloading.this.rate2 = 0.55f * value;
            MaMDownloading.this.rate3 = 2.0f * MaMDownloading.this.rate1;
            MaMDownloading.this.updateCtrlPoint();
            Log.i((String)MaMDownloading.TAG, (String)("circlePaintAlpha = " + MaMDownloading.this.circlePaintAlpha));
            if (MaMDownloading.this.circlePaintAlpha > 0) {
                MaMDownloading.this.circlePaintAlpha = MaMDownloading.this.circlePaintAlpha - 5;
                MaMDownloading.this.circlePaintAlpha = MaMDownloading.this.circlePaintAlpha < 0 ? 0 : MaMDownloading.this.circlePaintAlpha;
            }
            MaMDownloading.this.invalidate();
        }
    };
    private ValueAnimator.AnimatorUpdateListener C2LUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            float value = ((Float)animation.getAnimatedValue()).floatValue();
            ((MaMDownloading)MaMDownloading.this).startP.y = ((MaMDownloading)MaMDownloading.this).center.y + (1.0f - value) * MaMDownloading.this.circleRadius;
            ((MaMDownloading)MaMDownloading.this).stopPR.x = ((MaMDownloading)MaMDownloading.this).center.x + value * 3.8f * MaMDownloading.this.circleRadius;
            ((MaMDownloading)MaMDownloading.this).stopPR.y = ((MaMDownloading)MaMDownloading.this).center.y - (1.0f - value) * MaMDownloading.this.circleRadius;
            ((MaMDownloading)MaMDownloading.this).stopPL.x = ((MaMDownloading)MaMDownloading.this).center.x - value * 3.8f * MaMDownloading.this.circleRadius;
            ((MaMDownloading)MaMDownloading.this).stopPL.y = ((MaMDownloading)MaMDownloading.this).center.y - (1.0f - value) * MaMDownloading.this.circleRadius;
            ((MaMDownloading)MaMDownloading.this).ctrlL1.y = ((MaMDownloading)MaMDownloading.this).center.y + (1.0f - value) * MaMDownloading.this.circleRadius;
            ((MaMDownloading)MaMDownloading.this).ctrlL2.y = ((MaMDownloading)MaMDownloading.this).center.y - MaMDownloading.this.circleRadius + value * MaMDownloading.this.circleRadius;
            ((MaMDownloading)MaMDownloading.this).ctrlR1.y = ((MaMDownloading)MaMDownloading.this).center.y + (1.0f - value) * MaMDownloading.this.circleRadius;
            ((MaMDownloading)MaMDownloading.this).ctrlR2.y = ((MaMDownloading)MaMDownloading.this).center.y - MaMDownloading.this.circleRadius + value * MaMDownloading.this.circleRadius;
            MaMDownloading.this.invalidate();
        }
    };
    private ValueAnimator.AnimatorUpdateListener LJumpUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            float value = ((Float)animation.getAnimatedValue()).floatValue();
            ((MaMDownloading)MaMDownloading.this).lineCenter.y = ((MaMDownloading)MaMDownloading.this).center.y + value * MaMDownloading.this.circleRadius;
            Log.d((String)MaMDownloading.TAG, (String)("LJumpUpdateListener  value = " + value));
            if (!MaMDownloading.this.JUMP_HIGHEST && value <= -2.1f) {
                MaMDownloading.this.JUMP_HIGHEST = true;
                MaMDownloading.this.arrowToRectAnim.start();
                MaMDownloading.this.jumpHightY = ((MaMDownloading)MaMDownloading.this).lineCenter.y;
                MaMDownloading.this.distance = ((MaMDownloading)MaMDownloading.this).center.y - MaMDownloading.this.jumpHightY;
            }
            MaMDownloading.this.invalidate();
        }
    };
    private float radius = this.circleRadius;
    private ValueAnimator.AnimatorUpdateListener arrowToCircleAnimListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            float value = ((Float)animation.getAnimatedValue()).floatValue();
            ((MaMDownloading)MaMDownloading.this).arrowCenter.y = MaMDownloading.this.jumpHightY + MaMDownloading.this.distance * value - MaMDownloading.this.rate3 * MaMDownloading.this.circleRadius;
            if (value > 0.0f && value <= 1.0f) {
                MaMDownloading.this.radius = MaMDownloading.this.circleRadius + value * MaMDownloading.this.circleRadius;
                float valueH = value * 0.4f;
                MaMDownloading.this.arrowP0 = new Point(((MaMDownloading)MaMDownloading.this).arrowCenter.x - (MaMDownloading.this.rate1 + valueH) * MaMDownloading.this.circleRadius, ((MaMDownloading)MaMDownloading.this).arrowCenter.y - MaMDownloading.this.rate2 * value * MaMDownloading.this.circleRadius);
                MaMDownloading.this.arrowP1 = new Point(((MaMDownloading)MaMDownloading.this).arrowCenter.x - MaMDownloading.this.rate1 * MaMDownloading.this.circleRadius, ((MaMDownloading)MaMDownloading.this).arrowCenter.y - MaMDownloading.this.circleRadius * MaMDownloading.this.rate2);
                MaMDownloading.this.arrowP2 = new Point(((MaMDownloading)MaMDownloading.this).arrowCenter.x + MaMDownloading.this.rate1 * MaMDownloading.this.circleRadius, ((MaMDownloading)MaMDownloading.this).arrowCenter.y - MaMDownloading.this.circleRadius * MaMDownloading.this.rate2);
                MaMDownloading.this.arrowP3 = new Point(((MaMDownloading)MaMDownloading.this).arrowCenter.x + (MaMDownloading.this.rate1 + valueH) * MaMDownloading.this.circleRadius, ((MaMDownloading)MaMDownloading.this).arrowCenter.y - MaMDownloading.this.rate2 * value * MaMDownloading.this.circleRadius);
                MaMDownloading.this.arrowP4 = new Point(((MaMDownloading)MaMDownloading.this).arrowCenter.x + (MaMDownloading.this.rate3 - MaMDownloading.this.rate1 + valueH) * MaMDownloading.this.circleRadius, ((MaMDownloading)MaMDownloading.this).arrowCenter.y + value * MaMDownloading.this.rate3 * MaMDownloading.this.circleRadius);
                MaMDownloading.this.arrowP5 = new Point(((MaMDownloading)MaMDownloading.this).arrowCenter.x, ((MaMDownloading)MaMDownloading.this).arrowCenter.y + MaMDownloading.this.rate3 * MaMDownloading.this.circleRadius);
                MaMDownloading.this.arrowP6 = new Point(((MaMDownloading)MaMDownloading.this).arrowCenter.x - (MaMDownloading.this.rate3 + valueH - MaMDownloading.this.rate1) * MaMDownloading.this.circleRadius, ((MaMDownloading)MaMDownloading.this).arrowCenter.y + value * MaMDownloading.this.rate3 * MaMDownloading.this.circleRadius);
            } else {
                MaMDownloading.this.updateArrowPointByCenter();
            }
            MaMDownloading.this.invalidate();
        }
    };
    private ValueAnimator.AnimatorUpdateListener mergeAnimListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            float value = ((Float)animation.getAnimatedValue()).floatValue();
            float distance = ((MaMDownloading)MaMDownloading.this).center.y - MaMDownloading.this.arrowP0.y;
            MaMDownloading.this.arrowP0.y = ((MaMDownloading)MaMDownloading.this).center.y - (1.0f - value) * distance;
            MaMDownloading.this.arrowP1.y = ((MaMDownloading)MaMDownloading.this).center.y - (1.0f - value) * distance;
            MaMDownloading.this.arrowP2.y = ((MaMDownloading)MaMDownloading.this).center.y - (1.0f - value) * distance;
            MaMDownloading.this.arrowP3.y = ((MaMDownloading)MaMDownloading.this).center.y - (1.0f - value) * distance;
            MaMDownloading.this.barHeight = 5.0f + 25.0f * value;
            MaMDownloading.this.invalidate();
        }
    };

    public MaMDownloading(Context context) {
        super(context);
        this.init(context);
    }

    public MaMDownloading(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public MaMDownloading(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        this.outPaint = new Paint(1);
        this.outPaint.setStyle(Paint.Style.STROKE);
        this.outPaint.setColor(this.arrowColor);
        this.outPaint.setStrokeWidth(5.0f);
        this.innerPaint = new Paint(1);
        this.innerPaint.setStrokeWidth(5.0f);
        this.innerPaint.setStyle(Paint.Style.FILL);
        this.circlePaint = new Paint(1);
        this.circlePaint.setStyle(Paint.Style.FILL);
        this.pathLeft = new Path();
        this.pathRight = new Path();
        this.linePath = new Path();
        this.cornerRectPath = new Path();
        this.progressRectPath = new Path();
        LinearInterpolator linearInterpolator = new LinearInterpolator();
        this.scaleAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.85f, 1.0f});
        this.scaleAnim.setInterpolator((TimeInterpolator)linearInterpolator);
        this.scaleAnim.setDuration(350L);
        this.scaleAnim.addUpdateListener(this.scaleListener);
        this.scaleAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                MaMDownloading.this.nowDrawState = 4913;
                MaMDownloading.this.circleToLinePathAnim.start();
            }
        });
        this.circleToLinePathAnim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.circleToLinePathAnim.setInterpolator((TimeInterpolator)linearInterpolator);
        this.circleToLinePathAnim.setDuration(200L);
        this.circleToLinePathAnim.addUpdateListener(this.C2LUpdateListener);
        this.circleToLinePathAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                MaMDownloading.this.nowDrawState = 4914;
                MaMDownloading.this.lineJumpAnim.start();
            }
        });
        this.lineJumpAnim = ValueAnimator.ofFloat((float[])new float[]{0.0f, -2.5f, 1.3f, -1.0f, 0.5f, -0.2f, 0.0f});
        this.lineJumpAnim.setInterpolator((TimeInterpolator)linearInterpolator);
        this.lineJumpAnim.setDuration(450L);
        this.lineJumpAnim.addUpdateListener(this.LJumpUpdateListener);
        this.arrowToRectAnim = ValueAnimator.ofFloat((float[])new float[]{0.0f, -0.5f, 1.0f});
        this.arrowToRectAnim.setInterpolator((TimeInterpolator)linearInterpolator);
        this.arrowToRectAnim.setDuration(350L);
        this.arrowToRectAnim.addUpdateListener(this.arrowToCircleAnimListener);
        this.arrowToRectAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                MaMDownloading.this.nowDrawState = 4915;
                MaMDownloading.this.mergeAnim.start();
                super.onAnimationEnd(animation);
            }
        });
        this.mergeAnim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.mergeAnim.setInterpolator((TimeInterpolator)linearInterpolator);
        this.mergeAnim.setDuration(350L);
        this.mergeAnim.addUpdateListener(this.mergeAnimListener);
        this.mergeAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                MaMDownloading.this.JUMP_HIGHEST = false;
                MaMDownloading.this.radius = MaMDownloading.this.circleRadius;
                MaMDownloading.this.arrowCenter = new Point(((MaMDownloading)MaMDownloading.this).center.x, ((MaMDownloading)MaMDownloading.this).center.y);
                MaMDownloading.this.circlePaintAlpha = 255;
                super.onAnimationEnd(animation);
            }
        });
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.nowDrawState == 4649) {
            this.drawInnerCircle(canvas, this.circlePaintAlpha);
            this.drawCurvePath(canvas);
            this.drawArrow(canvas);
        } else if (this.nowDrawState == 4913) {
            this.drawCurvePath(canvas);
            if (this.startP.y <= this.center.y + this.rate3 * this.circleRadius) {
                this.arrowCenter.y = this.startP.y - this.rate3 * this.circleRadius;
                this.drawArrow(canvas);
            } else {
                this.drawArrow(canvas);
            }
        } else if (this.nowDrawState == 4914) {
            this.drawLinePath(canvas);
            if (!this.JUMP_HIGHEST) {
                this.arrowCenter.y = this.lineCenter.y - this.rate3 * this.circleRadius;
                this.drawArrow(canvas);
            } else {
                this.drawArrowToRect(canvas, this.radius);
            }
        } else if (this.nowDrawState == 4915) {
            this.drawArrowToRect(canvas, this.radius);
            this.drawLoadingBar(canvas, this.barHeight);
        }
    }

    private void drawLinePath(Canvas canvas) {
        this.outPaint.setStyle(Paint.Style.STROKE);
        this.linePath.reset();
        this.linePath.moveTo(this.stopPL.x, this.stopPL.y);
        this.linePath.quadTo(this.lineCenter.x, this.lineCenter.y, this.stopPR.x, this.stopPR.y);
        canvas.drawPath(this.linePath, this.outPaint);
    }

    private void drawCurvePath(Canvas canvas) {
        this.outPaint.setStyle(Paint.Style.STROKE);
        this.pathLeft.reset();
        this.pathRight.reset();
        this.pathLeft.moveTo(this.startP.x, this.startP.y);
        this.pathRight.moveTo(this.startP.x, this.startP.y);
        this.pathLeft.cubicTo(this.ctrlL1.x, this.ctrlL1.y, this.ctrlL2.x, this.ctrlL2.y, this.stopPL.x, this.stopPL.y);
        this.pathRight.cubicTo(this.ctrlR1.x, this.ctrlR1.y, this.ctrlR2.x, this.ctrlR2.y, this.stopPR.x, this.stopPR.y);
        canvas.drawPath(this.pathLeft, this.outPaint);
        canvas.drawPath(this.pathRight, this.outPaint);
    }

    private void drawInnerCircle(Canvas canvas, int alpha) {
        Path circlePath = new Path();
        circlePath.moveTo(this.startP.x, this.startP.y);
        circlePath.cubicTo(this.ctrlL1.x, this.ctrlL1.y, this.ctrlL2.x, this.ctrlL2.y, this.stopPL.x, this.stopPL.y);
        circlePath.cubicTo(this.ctrlR2.x, this.ctrlR2.y, this.ctrlR1.x, this.ctrlR1.y, this.startP.x, this.startP.y);
        this.circlePaint.setColor(this.circleColor);
        this.circlePaint.setAlpha(alpha);
        canvas.drawPath(circlePath, this.circlePaint);
    }

    private void initData() {
        this.center = new Point((float)this.vWidth / 2.0f, (float)this.vHeight / 2.0f);
        float base = this.vWidth > this.vHeight ? (float)this.vWidth : (float)this.vHeight;
        this.circleRadius = base * 0.8f / 8.0f;
        this.lineCenter = new Point(this.center.x, this.center.y);
        this.updateCtrlPoint();
        this.arrowCenter = new Point(this.center.x, this.center.y);
    }

    private void updateCtrlPoint() {
        this.startP = new Point(this.center.x, this.center.y + this.ctrlHRate * this.circleRadius);
        this.stopPL = new Point(this.center.x, this.center.y - this.ctrlHRate * this.circleRadius);
        this.stopPR = new Point(this.center.x, this.center.y - this.ctrlHRate * this.circleRadius);
        this.ctrlL1 = new Point(this.center.x - this.ctrlWRate * this.circleRadius, this.center.y + this.ctrlHRate * this.circleRadius);
        this.ctrlL2 = new Point(this.center.x - this.ctrlWRate * this.circleRadius, this.center.y - this.ctrlHRate * this.circleRadius);
        this.ctrlR1 = new Point(this.center.x + this.ctrlWRate * this.circleRadius, this.center.y + this.ctrlHRate * this.circleRadius);
        this.ctrlR2 = new Point(this.center.x + this.ctrlWRate * this.circleRadius, this.center.y - this.ctrlHRate * this.circleRadius);
    }

    private void drawArrow(Canvas canvas) {
        this.innerPaint.setPathEffect(null);
        this.innerPaint.setColor(this.arrowColor);
        this.updateArrowPointByCenter();
        Path arrowPath = this.createArrowPath();
        canvas.drawPath(arrowPath, this.innerPaint);
    }

    private void drawArrowToRect(Canvas canvas, float radius) {
        this.innerPaint.setPathEffect((PathEffect)new CornerPathEffect(radius));
        this.innerPaint.setColor(this.arrowColor);
        Path path = this.createArrowPath();
        canvas.drawPath(path, this.innerPaint);
    }

    private void drawLoadingBar(Canvas canvas, float height) {
        this.innerPaint.setStyle(Paint.Style.FILL);
        this.innerPaint.setPathEffect((PathEffect)new CornerPathEffect(30.0f));
        Point lu = new Point(this.stopPL.x, this.stopPL.y - height);
        Point rd = new Point(this.stopPR.x, this.stopPR.y + height);
        float length = this.stopPR.x - this.stopPL.x;
        this.innerPaint.setTextSize(35.0f);
        this.innerPaint.setColor(this.arrowColor);
        this.cornerRectPath.reset();
        this.cornerRectPath.moveTo(lu.x, lu.y);
        this.cornerRectPath.lineTo(rd.x, lu.y);
        this.cornerRectPath.lineTo(rd.x, rd.y);
        this.cornerRectPath.lineTo(lu.x, rd.y);
        this.cornerRectPath.close();
        canvas.drawPath(this.cornerRectPath, this.innerPaint);
        this.innerPaint.setColor(this.circleColor);
        this.progressRectPath.reset();
        this.progressRectPath.moveTo(lu.x, lu.y);
        this.progressRectPath.lineTo(lu.x + (float)this.progress * 0.01f * length, lu.y);
        this.progressRectPath.lineTo(lu.x + (float)this.progress * 0.01f * length, rd.y);
        this.progressRectPath.lineTo(lu.x, rd.y);
        this.progressRectPath.close();
        canvas.drawPath(this.progressRectPath, this.innerPaint);
        String text = this.progress + "%";
        this.innerPaint.setColor(this.arrowColor);
        canvas.drawText(text, lu.x + (float)this.progress * 0.01f * length - (float)(text.length() * 25), this.stopPR.y + 10.0f, this.innerPaint);
    }

    private void updateArrowPointByCenter() {
        this.arrowP0 = new Point(this.arrowCenter.x - this.rate1 * this.circleRadius, this.arrowCenter.y);
        this.arrowP1 = new Point(this.arrowCenter.x - this.rate1 * this.circleRadius, this.arrowCenter.y - this.circleRadius * this.rate2);
        this.arrowP2 = new Point(this.arrowCenter.x + this.rate1 * this.circleRadius, this.arrowCenter.y - this.circleRadius * this.rate2);
        this.arrowP3 = new Point(this.arrowCenter.x + this.rate1 * this.circleRadius, this.arrowCenter.y);
        this.arrowP4 = new Point(this.arrowCenter.x + this.rate3 * this.circleRadius, this.arrowCenter.y);
        this.arrowP5 = new Point(this.arrowCenter.x, this.arrowCenter.y + this.rate3 * this.circleRadius);
        this.arrowP6 = new Point(this.arrowCenter.x - this.rate3 * this.circleRadius, this.arrowCenter.y);
    }

    private Path createArrowPath() {
        Path arrowPath = new Path();
        arrowPath.moveTo(this.arrowP0.x, this.arrowP0.y);
        arrowPath.lineTo(this.arrowP1.x, this.arrowP1.y);
        arrowPath.lineTo(this.arrowP2.x, this.arrowP2.y);
        arrowPath.lineTo(this.arrowP3.x, this.arrowP3.y);
        arrowPath.lineTo(this.arrowP4.x, this.arrowP4.y);
        arrowPath.lineTo(this.arrowP5.x, this.arrowP5.y);
        arrowPath.lineTo(this.arrowP6.x, this.arrowP6.y);
        arrowPath.close();
        return arrowPath;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.vHeight = this.getMeasuredHeight();
        this.vWidth = this.getMeasuredWidth();
        this.initData();
    }

    public void setProgress(int progress) {
        this.progress = progress;
        if (progress == 100) {
            this.isDownloading = false;
        }
        this.invalidate();
    }

    public void setCircleColor(int circleColor) {
        this.circleColor = circleColor;
    }

    public void setArrowColor(int arrowColor) {
        this.arrowColor = arrowColor;
    }

    public boolean startDownload() {
        if (!this.isDownloading) {
            this.progress = 0;
            this.isDownloading = true;
            this.nowDrawState = 4649;
            this.scaleAnim.start();
            return true;
        }
        return false;
    }

    public void stopDownloading() {
        this.isDownloading = false;
        this.scaleAnim.cancel();
        this.circleToLinePathAnim.cancel();
        this.lineJumpAnim.cancel();
        this.mergeAnim.cancel();
        this.nowDrawState = 4649;
        this.invalidate();
    }

    public boolean isDownloading() {
        return this.isDownloading;
    }

    private class Point {
        float x;
        float y;

        public Point(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public Point() {
        }
    }
}

