/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.widget.stateview;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.support.annotation.DrawableRes;
import android.text.TextUtils;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.xdja.baselibrary.R;
import com.xdja.baselibrary.widget.stateview.StatusLayoutManager;

public class SwitchStatusLayoutManager {
    private static final int DEFAULT_LOADING_LAYOUT_ID = R.layout.moments_layout_base_loading;
    private static final int DEFAULT_EMPTY_LAYOUT_ID = R.layout.moments_layout_base_empty;
    private static final int DEFAULT_ERROR_LAYOUT_ID = R.layout.moments_layout_base_error;
    private static final int DEFAULT_NO_NETWORK_LAYOUT_ID = R.layout.moments_layout_base_no_network;
    private int mViewIndex;
    private Object mTarget;
    private LayoutInflater mInflater;
    private int mCurrentStatus;
    private View mContentLayout;
    private ViewGroup mParentLayout;
    private SparseIntArray mStatusViewMap;
    private SparseArray<View> mStatusViews;
    private SparseArray<View.OnClickListener> mClickListeners;
    private ViewGroup.LayoutParams mLayoutParams;

    public SwitchStatusLayoutManager(StatusLayoutManager multiStatusLayoutManager) {
        this.mTarget = multiStatusLayoutManager.getTarget();
        this.mStatusViewMap = multiStatusLayoutManager.getStatusViewMap();
        this.mClickListeners = multiStatusLayoutManager.getClickListeners();
        this.getContentLayoutParams();
        this.initStatusViews();
        this.initStatusViewClickListeners();
        int count = this.mParentLayout.getChildCount();
        for (int index = 0; index < count; ++index) {
            if (this.mContentLayout != this.mParentLayout.getChildAt(index)) continue;
            this.mViewIndex = index;
            break;
        }
    }

    private void initStatusViews() {
        if (this.mStatusViews == null) {
            this.mStatusViews = new SparseArray();
        }
        if (this.mStatusViewMap == null) {
            this.mStatusViewMap = new SparseIntArray();
        }
        if (this.mStatusViewMap.get(3) == 0) {
            this.mStatusViewMap.put(3, DEFAULT_EMPTY_LAYOUT_ID);
        }
        if (this.mStatusViewMap.get(2) == 0) {
            this.mStatusViewMap.put(2, DEFAULT_ERROR_LAYOUT_ID);
        }
        if (this.mStatusViewMap.get(4) == 0) {
            this.mStatusViewMap.put(4, DEFAULT_NO_NETWORK_LAYOUT_ID);
        }
        if (this.mStatusViewMap.get(1) == 0) {
            this.mStatusViewMap.put(1, DEFAULT_LOADING_LAYOUT_ID);
        }
        for (int i = 0; i < this.mStatusViewMap.size(); ++i) {
            int key = this.mStatusViewMap.keyAt(i);
            int value = this.mStatusViewMap.valueAt(i);
            View view = this.mInflater.inflate(value, null);
            if (view == null) continue;
            this.mStatusViews.put(key, (Object)view);
        }
        this.mStatusViews.put(0, (Object)this.mContentLayout);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getContentLayoutParams() {
        if (this.mTarget == null) {
            throw new NullPointerException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Activity context = null;
        if (this.mTarget instanceof Activity) {
            context = (Activity)this.mTarget;
            this.mParentLayout = (ViewGroup)context.findViewById(0x1020002);
            this.mContentLayout = this.mParentLayout != null ? this.mParentLayout.getChildAt(0) : null;
        } else if (this.mTarget instanceof View) {
            this.mContentLayout = (View)this.mTarget;
            context = ((View)this.mTarget).getContext();
            this.mParentLayout = (ViewGroup)this.mContentLayout.getParent();
            if (this.mParentLayout == null) {
                if (!(this.mContentLayout instanceof ViewGroup)) throw new IllegalArgumentException("\u53c2\u6570\u5fc5\u987b\u4e3aViewGroup\u6216\u8005\u6709\u76f4\u63a5\u7236\u63a7\u4ef6");
                this.mParentLayout = (ViewGroup)this.mContentLayout;
            }
        } else if (this.mTarget instanceof Fragment) {
            this.mContentLayout = ((Fragment)this.mTarget).getView();
            context = ((Fragment)this.mTarget).getActivity();
            this.mParentLayout = (ViewGroup)this.mContentLayout.getParent();
        } else {
            if (!(this.mTarget instanceof Fragment)) throw new IllegalArgumentException("\u53c2\u6570\u5fc5\u987b\u4e3aview\u3001Fragment\u6216\u8005Activity\u7c7b\u578b");
            this.mContentLayout = ((Fragment)this.mTarget).getView();
            context = ((Fragment)this.mTarget).getActivity();
            this.mParentLayout = (ViewGroup)this.mContentLayout.getParent();
        }
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mLayoutParams = this.mContentLayout.getLayoutParams();
    }

    private void initStatusViewClickListeners() {
        if (this.mClickListeners == null) {
            this.mClickListeners = new SparseArray();
        }
    }

    public void showLoadingView() {
        this.showStatusView(1);
    }

    public void showLoadingView(String loadingText) {
        this.showStatusView(1, loadingText);
    }

    public void showErrorView() {
        this.showStatusView(2);
    }

    public void showErrorView(String errorText) {
        this.showStatusView(2, errorText);
    }

    public void showErrorView(String errorText, @DrawableRes int errorImage) {
        this.showStatusView(2, errorText, errorImage);
    }

    public void showEmptyView() {
        this.showStatusView(3);
    }

    public void showEmptyView(String emptyText) {
        this.showStatusView(3, emptyText);
    }

    public void showEmptyView(String emptyText, @DrawableRes int emptyImage) {
        this.showStatusView(3, emptyText, emptyImage);
    }

    public void showNoNetWorkView() {
        this.showStatusView(4);
    }

    public void showNoNetWorkView(String noNetworkText) {
        this.showStatusView(4, noNetworkText);
    }

    public void showNoNetWorkView(String noNetworkText, @DrawableRes int netErrorImage) {
        this.showStatusView(4, noNetworkText, netErrorImage);
    }

    public void showContentView() {
        this.showStatusView(0);
    }

    public void hideContentView() {
        this.hideStatusView(0);
    }

    private void showStatusView(int statusType) {
        this.showStatusView(statusType, null);
    }

    private void showStatusView(int statusType, String text) {
        this.showStatusView(statusType, text, R.drawable.img_net_error);
    }

    private void showStatusView(int statusType, String text, @DrawableRes int imageId) {
        View view;
        this.checkStatusViewExist(statusType);
        if (this.mCurrentStatus != -1) {
            if (this.mCurrentStatus == statusType) {
                return;
            }
            if (this.mParentLayout != null) {
                this.mParentLayout.removeView((View)this.mStatusViews.get(this.mCurrentStatus));
            }
        }
        if ((view = (View)this.mStatusViews.get(statusType)) != null) {
            ImageView image;
            TextView info;
            View.OnClickListener clickListener;
            if (this.mClickListeners != null && (clickListener = (View.OnClickListener)this.mClickListeners.get(statusType)) != null) {
                view.setOnClickListener(clickListener);
            }
            if ((info = (TextView)view.findViewById(R.id.info)) != null && !TextUtils.isEmpty((CharSequence)text)) {
                info.setText((CharSequence)text);
            }
            if ((image = (ImageView)view.findViewById(R.id.iv_cover_image)) != null) {
                image.setImageResource(imageId);
            }
        } else {
            throw new IllegalArgumentException(String.format("the status (%d) layout is  not exist", statusType));
        }
        this.mParentLayout.addView(view, this.mViewIndex, this.mLayoutParams);
        this.mCurrentStatus = statusType;
    }

    public void hideStatusView(int statusType) {
        if (this.mStatusViews == null || this.mStatusViews.get(statusType) == null) {
            return;
        }
        if (this.mCurrentStatus != -1 && this.mParentLayout != null) {
            this.mParentLayout.removeView((View)this.mStatusViews.get(this.mCurrentStatus));
        }
        this.mCurrentStatus = -1;
    }

    private void checkStatusViewExist(int statusType) {
        if (this.mStatusViews == null || this.mStatusViews.get(statusType) == null) {
            this.initStatusViews();
        }
    }

    public void addStatusView(int statusType, int id2) {
        View view = View.inflate((Context)this.mContentLayout.getContext(), (int)id2, null);
        if (view != null) {
            this.mStatusViews.put(statusType, (Object)view);
        }
    }

    public void release() {
        if (this.mClickListeners != null) {
            this.mClickListeners.clear();
        }
        if (this.mStatusViewMap != null) {
            this.mStatusViewMap.clear();
        }
        if (this.mStatusViews != null) {
            this.mStatusViews.clear();
        }
    }
}

