/*
 * Decompiled with CFR 0.152.
 */
package com.moments.filepicker.adapters;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.ToggleButton;
import com.bumptech.glide.Glide;
import com.moments.filepicker.FilePickerConst;
import com.moments.filepicker.PickerManager;
import com.moments.filepicker.R;
import com.moments.filepicker.adapters.FileAdapterListener;
import com.moments.filepicker.adapters.SelectableAdapter;
import com.moments.filepicker.models.BaseFile;
import com.moments.filepicker.models.PickFile;
import com.moments.filepicker.selection.ItemClickListener;
import com.moments.filepicker.selection.Section;
import com.moments.filepicker.utils.DensityUtil;
import com.moments.filepicker.utils.FileUtils;
import com.xdja.baselibrary.widget.SmoothCheckBox;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class FileListAdapter
extends SelectableAdapter<FileViewHolder, BaseFile>
implements Filterable {
    private final Context context;
    private final FileAdapterListener mListener;
    private final ItemClickListener mItemClickListener;
    private List<BaseFile> mFilteredList;
    private static final int VIEW_TYPE_SECTION = R.layout.moments_filepicker_item_selection_layout;
    private static final int VIEW_TYPE_ITEM = R.layout.moments_filepicker_item_doc_layout;

    public FileListAdapter(Context context, CopyOnWriteArrayList<BaseFile> items, List<String> selectedPaths, FileAdapterListener fileAdapterListener, ItemClickListener itemClickListener) {
        super(items, selectedPaths);
        this.mFilteredList = items;
        this.context = context;
        this.mListener = fileAdapterListener;
        this.mItemClickListener = itemClickListener;
    }

    public FileViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new FileViewHolder(LayoutInflater.from((Context)this.context).inflate(viewType, parent, false), viewType);
    }

    private boolean isSection(int position) {
        return this.mFilteredList.get(position) instanceof Section;
    }

    public int getItemViewType(int position) {
        if (this.isSection(position)) {
            return VIEW_TYPE_SECTION;
        }
        return VIEW_TYPE_ITEM;
    }

    public void onBindViewHolder(final FileViewHolder holder, final int position) {
        if (holder.viewType == VIEW_TYPE_ITEM) {
            final PickFile pickFile = (PickFile)this.mFilteredList.get(position);
            int drawable2 = pickFile.getFileType().getDrawable(pickFile.getPath());
            if (FileUtils.getFileType(pickFile.getPath()) == FilePickerConst.FILE_TYPE.IMAGE || FileUtils.getFileType(pickFile.getPath()) == FilePickerConst.FILE_TYPE.VIDEO) {
                Glide.with((Context)this.context).load(pickFile.getPath()).asBitmap().placeholder(drawable2).error(drawable2).override(DensityUtil.dip2px(this.context, 40.0f), DensityUtil.dip2px(this.context, 40.0f)).centerCrop().into(holder.imageView);
            } else {
                Glide.with((Context)this.context).load(Integer.valueOf(drawable2)).centerCrop().override(DensityUtil.dip2px(this.context, 40.0f), DensityUtil.dip2px(this.context, 40.0f)).into(holder.imageView);
            }
            if (drawable2 == R.drawable.filepicker_icon_file_unknown) {
                holder.fileTypeTv.setVisibility(0);
                holder.fileTypeTv.setText((CharSequence)pickFile.getFileType().title);
            } else {
                holder.fileTypeTv.setVisibility(8);
            }
            holder.fileNameTextView.setText((CharSequence)pickFile.getTitle());
            holder.fileSizeTextView.setText((CharSequence)FileUtils.getSizeString(FileUtils.getFileSize(pickFile.getPath())));
            long addData = pickFile.getAddData() * 1000L;
            String addTime = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(addData);
            holder.fileAddDateTextView.setText((CharSequence)addTime);
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    FileListAdapter.this.onItemClicked(pickFile, holder);
                }
            });
            holder.checkBox.setOnCheckedChangeListener(null);
            holder.checkBox.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    FileListAdapter.this.onItemClicked(pickFile, holder);
                }
            });
            holder.checkBox.setChecked(this.isSelected(pickFile));
            holder.itemView.setBackgroundResource(this.isSelected(pickFile) ? R.color.bg_gray : 17170443);
            holder.checkBox.setVisibility(this.isSelected(pickFile) ? 0 : 8);
            holder.checkBox.setOnCheckedChangeListener(new SmoothCheckBox.OnCheckedChangeListener(){

                public void onCheckedChanged(SmoothCheckBox checkBox, boolean isChecked) {
                    FileListAdapter.this.toggleSelection(pickFile);
                    holder.itemView.setBackgroundResource(isChecked ? R.color.bg_gray : 17170443);
                }
            });
            if (FileUtils.getFileType(pickFile.getPath()) == FilePickerConst.FILE_TYPE.VIDEO) {
                holder.videoPrev.setVisibility(0);
            } else {
                holder.videoPrev.setVisibility(8);
            }
        } else if (holder.viewType == VIEW_TYPE_SECTION) {
            if (position == this.mFilteredList.size() - 1) {
                holder.line2.setVisibility(0);
                holder.line1.setVisibility(8);
            } else {
                holder.line1.setVisibility(0);
                holder.line2.setVisibility(8);
            }
            final Section section = (Section)this.mFilteredList.get(position);
            holder.sectionTextView.setText((CharSequence)section.getName());
            holder.llSection.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    FileListAdapter.this.mItemClickListener.itemClicked(section, position);
                }
            });
            holder.sectionToggleButton.setChecked(section.isExpanded);
        }
    }

    private void onItemClicked(PickFile pickFile, FileViewHolder holder) {
        if (!FileUtils.isFileExist(pickFile.getPath())) {
            Toast.makeText((Context)this.context, (int)R.string.file_delete, (int)0).show();
            holder.checkBox.setChecked(false);
            return;
        }
        if (Integer.valueOf(pickFile.getSize()) > PickerManager.getInstance().getMaxFileSize()) {
            Toast.makeText((Context)this.context, (CharSequence)("\u53ea\u80fd\u9009\u62e9" + PickerManager.getInstance().getMaxFileSizeMB() + "M\u4ee5\u5185\u7684\u6587\u4ef6"), (int)0).show();
            return;
        }
        if (Integer.valueOf(pickFile.getSize()) == 0) {
            Toast.makeText((Context)this.context, (CharSequence)"\u4e0d\u80fd\u9009\u62e9\u7a7a\u767d\u6587\u4ef6", (int)0).show();
            return;
        }
        if (PickerManager.getInstance().getMaxCount() == 1) {
            PickerManager.getInstance().add(pickFile.getPath(), 2);
        } else if (holder.checkBox.isChecked()) {
            PickerManager.getInstance().remove(pickFile.getPath(), 2);
            holder.checkBox.setChecked(!holder.checkBox.isChecked(), true);
            holder.checkBox.setVisibility(8);
        } else if (PickerManager.getInstance().shouldAdd()) {
            PickerManager.getInstance().add(pickFile.getPath(), 2);
            holder.checkBox.setChecked(!holder.checkBox.isChecked(), true);
            holder.checkBox.setVisibility(0);
        } else {
            Toast.makeText((Context)this.context, (CharSequence)("\u6700\u591a\u9009\u62e9" + PickerManager.getInstance().getMaxCount() + "\u4e2a\u6587\u4ef6"), (int)0).show();
        }
        if (this.mListener != null) {
            this.mListener.onItemSelected();
        }
    }

    public int getItemCount() {
        return this.mFilteredList == null ? 0 : this.mFilteredList.size();
    }

    public Filter getFilter() {
        return new Filter(){

            protected Filter.FilterResults performFiltering(CharSequence charSequence) {
                String charString = charSequence.toString();
                if (charString.isEmpty()) {
                    FileListAdapter.this.mFilteredList = FileListAdapter.this.getItems();
                } else {
                    ArrayList<PickFile> filteredList = new ArrayList<PickFile>();
                    for (BaseFile baseFile : FileListAdapter.this.getItems()) {
                        PickFile pickFile = (PickFile)baseFile;
                        if (!pickFile.getTitle().toLowerCase().contains(charString)) continue;
                        filteredList.add(pickFile);
                    }
                    FileListAdapter.this.mFilteredList = filteredList;
                }
                Filter.FilterResults filterResults = new Filter.FilterResults();
                filterResults.values = FileListAdapter.this.mFilteredList;
                return filterResults;
            }

            protected void publishResults(CharSequence charSequence, Filter.FilterResults filterResults) {
                FileListAdapter.this.mFilteredList = (CopyOnWriteArrayList)filterResults.values;
                FileListAdapter.this.notifyDataSetChanged();
            }
        };
    }

    public static class FileViewHolder
    extends RecyclerView.ViewHolder {
        int viewType;
        TextView fileTypeTv;
        RelativeLayout doc_layout;
        SmoothCheckBox checkBox;
        ImageView imageView;
        TextView fileNameTextView;
        TextView fileSizeTextView;
        TextView fileAddDateTextView;
        ImageView videoPrev;
        TextView sectionTextView;
        ToggleButton sectionToggleButton;
        RelativeLayout llSection;
        View line1;
        View line2;

        public FileViewHolder(View itemView, int viewType) {
            super(itemView);
            this.viewType = viewType;
            if (viewType == VIEW_TYPE_ITEM) {
                this.checkBox = (SmoothCheckBox)itemView.findViewById(R.id.checkbox);
                this.doc_layout = (RelativeLayout)itemView.findViewById(R.id.doc_layout);
                this.imageView = (ImageView)itemView.findViewById(R.id.file_iv);
                this.videoPrev = (ImageView)itemView.findViewById(R.id.file_video_prev);
                this.fileNameTextView = (TextView)itemView.findViewById(R.id.file_name_tv);
                this.fileAddDateTextView = (TextView)itemView.findViewById(R.id.file_date_tv);
                this.fileTypeTv = (TextView)itemView.findViewById(R.id.file_type_tv);
                this.fileSizeTextView = (TextView)itemView.findViewById(R.id.file_size_tv);
            } else {
                this.sectionTextView = (TextView)itemView.findViewById(R.id.tv_selection_name);
                this.llSection = (RelativeLayout)itemView.findViewById(R.id.ll_section);
                this.sectionToggleButton = (ToggleButton)itemView.findViewById(R.id.toggle_button_section);
                this.line1 = itemView.findViewById(R.id.line1);
                this.line2 = itemView.findViewById(R.id.line2);
            }
        }
    }
}

