/*
 * Decompiled with CFR 0.152.
 */
package com.moments.filepicker.fragments;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.moments.filepicker.PickerManager;
import com.moments.filepicker.R;
import com.moments.filepicker.adapters.FileAdapterListener;
import com.moments.filepicker.adapters.PhotoGridAdapter;
import com.moments.filepicker.cursors.loadercallbacks.FileResultCallback;
import com.moments.filepicker.fragments.BaseFragment;
import com.moments.filepicker.fragments.PhotoPickerFragmentListener;
import com.moments.filepicker.models.Media;
import com.moments.filepicker.models.PhotoDirectory;
import com.moments.filepicker.utils.AndroidLifecycleUtils;
import com.moments.filepicker.utils.ImageCaptureManager;
import com.moments.filepicker.utils.MediaStoreHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class MediaDetailPickerFragment
extends BaseFragment
implements FileAdapterListener {
    private static final String TAG = MediaDetailPickerFragment.class.getSimpleName();
    private static final int SCROLL_THRESHOLD = 30;
    RecyclerView recyclerView;
    TextView emptyView;
    private PhotoPickerFragmentListener mListener;
    private PhotoGridAdapter photoGridAdapter;
    private ImageCaptureManager imageCaptureManager;
    private RequestManager mGlideRequestManager;
    private int fileType;
    private MenuItem selectAllItem;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.moments_filepicker_fragment_photo_picker, container, false);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof PhotoPickerFragmentListener)) {
            throw new RuntimeException(context.toString() + " must implement PhotoPickerFragmentListener");
        }
        this.mListener = (PhotoPickerFragmentListener)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mListener = null;
    }

    public static MediaDetailPickerFragment newInstance(int fileType) {
        MediaDetailPickerFragment mediaDetailPickerFragment = new MediaDetailPickerFragment();
        Bundle bun = new Bundle();
        bun.putInt("FILE_TYPE", fileType);
        mediaDetailPickerFragment.setArguments(bun);
        return mediaDetailPickerFragment;
    }

    @Override
    public void onItemSelected() {
        this.mListener.onItemSelected();
        if (this.photoGridAdapter != null && this.selectAllItem != null && this.photoGridAdapter.getItemCount() == this.photoGridAdapter.getSelectedItemCount()) {
            this.selectAllItem.setIcon(R.drawable.filepicker_ic_select_all);
            this.selectAllItem.setChecked(true);
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(PickerManager.getInstance().hasSelectAll());
        this.mGlideRequestManager = Glide.with((Fragment)this);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView(view);
    }

    private void initView(View view) {
        this.recyclerView = (RecyclerView)view.findViewById(R.id.recyclerview);
        this.emptyView = (TextView)view.findViewById(R.id.empty_view);
        this.fileType = this.getArguments().getInt("FILE_TYPE");
        this.imageCaptureManager = new ImageCaptureManager((Context)this.getActivity());
        StaggeredGridLayoutManager layoutManager = new StaggeredGridLayoutManager(3, 1);
        layoutManager.setGapStrategy(2);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (Math.abs(dy) > 30) {
                    MediaDetailPickerFragment.this.mGlideRequestManager.pauseRequests();
                } else {
                    MediaDetailPickerFragment.this.resumeRequestsIfNotDestroyed();
                }
            }

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                if (newState == 0) {
                    MediaDetailPickerFragment.this.resumeRequestsIfNotDestroyed();
                }
            }
        });
    }

    public void onResume() {
        super.onResume();
        this.getDataFromMedia();
    }

    private void getDataFromMedia() {
        Bundle mediaStoreArgs = new Bundle();
        mediaStoreArgs.putInt("EXTRA_FILE_TYPE", this.fileType);
        if (this.fileType == 1) {
            MediaStoreHelper.getPhotoDirs(this.getActivity(), mediaStoreArgs, new FileResultCallback<PhotoDirectory>(){

                @Override
                public void onResultCallback(List<PhotoDirectory> dirs) {
                    MediaDetailPickerFragment.this.updateList(dirs);
                }
            });
        } else if (this.fileType == 3) {
            MediaStoreHelper.getVideoDirs(this.getActivity(), mediaStoreArgs, new FileResultCallback<PhotoDirectory>(){

                @Override
                public void onResultCallback(List<PhotoDirectory> dirs) {
                    MediaDetailPickerFragment.this.updateList(dirs);
                }
            });
        }
    }

    private void updateList(List<PhotoDirectory> dirs) {
        ArrayList<Media> medias = new ArrayList<Media>();
        for (int i = 0; i < dirs.size(); ++i) {
            medias.addAll(dirs.get(i).getMedias());
        }
        Collections.sort(medias, new Comparator<Media>(){

            @Override
            public int compare(Media a, Media b) {
                return b.getId() - a.getId();
            }
        });
        if (medias.size() > 0) {
            this.emptyView.setVisibility(8);
        } else {
            this.emptyView.setVisibility(0);
        }
        if (this.photoGridAdapter != null) {
            this.photoGridAdapter.setData(medias);
            this.photoGridAdapter.notifyDataSetChanged();
        } else {
            this.photoGridAdapter = new PhotoGridAdapter((Context)this.getActivity(), this.mGlideRequestManager, medias, PickerManager.getInstance().getSelectedPhotos(), this.fileType == 1 && PickerManager.getInstance().isEnableCamera(), this);
            this.recyclerView.setAdapter((RecyclerView.Adapter)this.photoGridAdapter);
            this.photoGridAdapter.setCameraListener(new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        Intent intent = MediaDetailPickerFragment.this.imageCaptureManager.dispatchTakePictureIntent((Context)MediaDetailPickerFragment.this.getActivity());
                        if (intent != null) {
                            MediaDetailPickerFragment.this.startActivityForResult(intent, 257);
                        } else {
                            Toast.makeText((Context)MediaDetailPickerFragment.this.getActivity(), (int)R.string.no_camera_exists, (int)0).show();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 257: {
                if (resultCode != -1) break;
                String imagePath = this.imageCaptureManager.notifyMediaStoreDatabase();
                if (imagePath != null && PickerManager.getInstance().getMaxCount() == 1) {
                    PickerManager.getInstance().add(imagePath, 1);
                    this.mListener.onItemSelected();
                    break;
                }
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        MediaDetailPickerFragment.this.getDataFromMedia();
                    }
                }, 1000L);
            }
        }
    }

    private void resumeRequestsIfNotDestroyed() {
        if (!AndroidLifecycleUtils.canLoadImage(this)) {
            return;
        }
        this.mGlideRequestManager.resumeRequests();
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        inflater.inflate(R.menu.filepicker_select_menu, menu2);
        this.selectAllItem = menu2.findItem(R.id.action_select);
        this.onItemSelected();
        super.onCreateOptionsMenu(menu2, inflater);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int itemId = item.getItemId();
        if (itemId == R.id.action_select) {
            if (this.photoGridAdapter != null) {
                this.photoGridAdapter.selectAll();
                if (this.selectAllItem != null) {
                    if (this.selectAllItem.isChecked()) {
                        PickerManager.getInstance().clearSelections();
                        this.photoGridAdapter.clearSelection();
                        this.selectAllItem.setIcon(R.drawable.filepicker_ic_deselect_all);
                    } else {
                        this.photoGridAdapter.selectAll();
                        PickerManager.getInstance().add(this.photoGridAdapter.getSelectedPaths(), 1);
                        this.selectAllItem.setIcon(R.drawable.filepicker_ic_select_all);
                    }
                }
                this.selectAllItem.setChecked(!this.selectAllItem.isChecked());
                this.mListener.onItemSelected();
            }
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
}

