/*
 * Decompiled with CFR 0.152.
 */
package com.moments.filepicker.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.DrawableRes;
import com.moments.filepicker.R;
import com.moments.filepicker.utils.FileUtils;

public class FileType
implements Parcelable {
    public String title;
    @DrawableRes
    public int drawable;
    public String[] extensions;
    public static final Parcelable.Creator<FileType> CREATOR = new Parcelable.Creator<FileType>(){

        public FileType createFromParcel(Parcel in) {
            return new FileType(in);
        }

        public FileType[] newArray(int size) {
            return new FileType[size];
        }
    };

    public FileType(String title, String[] extensions, int drawable2) {
        this.title = title;
        this.extensions = extensions;
        this.drawable = drawable2;
    }

    protected FileType(Parcel in) {
        this.title = in.readString();
        this.drawable = in.readInt();
        this.extensions = in.createStringArray();
    }

    public int getDrawable(String filePath) {
        switch (FileUtils.getFileType(filePath)) {
            case IMAGE: {
                return R.drawable.filepicker_icon_file_image;
            }
            case PDF: {
                return R.drawable.filepicker_icon_file_pdf;
            }
            case EXCEL: {
                return R.drawable.filepicker_icon_file_xls;
            }
            case WORD: {
                return R.drawable.filepicker_icon_file_doc;
            }
            case PPT: {
                return R.drawable.filepicker_icon_file_ppt;
            }
            case TXT: {
                return R.drawable.filepicker_icon_file_txt;
            }
            case VOICE: {
                return R.drawable.filepicker_icon_file_audio;
            }
            case VIDEO: {
                return R.drawable.filepicker_icon_file_video;
            }
        }
        if (this.drawable == 0) {
            return R.drawable.filepicker_icon_file_unknown;
        }
        return this.drawable;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.title);
        parcel.writeInt(this.drawable);
        parcel.writeStringArray(this.extensions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileType fileType = (FileType)o;
        return this.title != null ? this.title.equals(fileType.title) : fileType.title == null;
    }

    public int hashCode() {
        return this.title != null ? this.title.hashCode() : 0;
    }
}

