/*
 * Decompiled with CFR 0.152.
 */
package com.moments.filepicker.models;

import com.moments.filepicker.models.BaseFile;
import com.moments.filepicker.models.FileType;
import com.moments.filepicker.utils.FilePickerUtils;
import java.io.File;

public class PickFile
extends BaseFile {
    private String mimeType;
    private String size;
    private FileType fileType;
    private String dir;
    private long addData;

    public PickFile(int id2, String title, String path, long addData) {
        super(id2, title, path);
        this.addData = addData;
    }

    public PickFile() {
        super(0, null, null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PickFile)) {
            return false;
        }
        PickFile pickFile = (PickFile)o;
        return this.id == pickFile.id;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id2) {
        this.id = id2;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getTitle() {
        return new File(this.path).getName();
    }

    public void setTitle(String title) {
        this.name = title;
    }

    public boolean isThisType(String[] types) {
        return FilePickerUtils.contains(types, this.path);
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public void setFileType(FileType fileType) {
        this.fileType = fileType;
    }

    public long getAddData() {
        return this.addData;
    }

    public void setAddData(long addData) {
        this.addData = addData;
    }
}

