/*
 * Decompiled with CFR 0.152.
 */
package com.moments.filepicker.utils;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;

public class AndroidLifecycleUtils {
    public static boolean canLoadImage(Fragment fragment) {
        if (fragment == null) {
            return true;
        }
        FragmentActivity activity = fragment.getActivity();
        return AndroidLifecycleUtils.canLoadImage((Activity)activity);
    }

    public static boolean canLoadImage(Context context) {
        if (context == null) {
            return true;
        }
        if (!(context instanceof Activity)) {
            return true;
        }
        Activity activity = (Activity)context;
        return AndroidLifecycleUtils.canLoadImage(activity);
    }

    public static boolean canLoadImage(Activity activity) {
        boolean destroyed;
        if (activity == null) {
            return true;
        }
        boolean bl = destroyed = Build.VERSION.SDK_INT >= 17 && activity.isDestroyed();
        return !destroyed && !activity.isFinishing();
    }
}

