/*
 * Decompiled with CFR 0.152.
 */
package com.moments.filepicker.utils;

import android.database.DataSetObserver;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.TabLayout;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.widget.LinearLayout;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class TabLayoutHelper {
    protected TabLayout mTabLayout;
    protected ViewPager mViewPager;
    protected TabLayout.OnTabSelectedListener mUserOnTabSelectedListener;
    protected TabLayout.OnTabSelectedListener mInternalOnTabSelectedListener;
    protected FixedTabLayoutOnPageChangeListener mInternalTabLayoutOnPageChangeListener;
    protected ViewPager.OnAdapterChangeListener mInternalOnAdapterChangeListener;
    protected DataSetObserver mInternalDataSetObserver;
    protected Runnable mAdjustTabModeRunnable;
    protected Runnable mSetTabsFromPagerAdapterRunnable;
    protected Runnable mUpdateScrollPositionRunnable;
    protected boolean mAutoAdjustTabMode = false;
    protected boolean mDuringSetTabsFromPagerAdapter;

    public TabLayoutHelper(@NonNull TabLayout tabLayout, @NonNull ViewPager viewPager) {
        PagerAdapter adapter = viewPager.getAdapter();
        if (adapter == null) {
            throw new IllegalArgumentException("ViewPager does not have a PagerAdapter set");
        }
        this.mTabLayout = tabLayout;
        this.mViewPager = viewPager;
        this.mInternalDataSetObserver = new DataSetObserver(){

            public void onChanged() {
                TabLayoutHelper.this.handleOnDataSetChanged();
            }
        };
        this.mInternalOnTabSelectedListener = new TabLayout.OnTabSelectedListener(){

            public void onTabSelected(TabLayout.Tab tab) {
                TabLayoutHelper.this.handleOnTabSelected(tab);
            }

            public void onTabUnselected(TabLayout.Tab tab) {
                TabLayoutHelper.this.handleOnTabUnselected(tab);
            }

            public void onTabReselected(TabLayout.Tab tab) {
                TabLayoutHelper.this.handleOnTabReselected(tab);
            }
        };
        this.mInternalTabLayoutOnPageChangeListener = new FixedTabLayoutOnPageChangeListener(this.mTabLayout);
        this.mInternalOnAdapterChangeListener = new ViewPager.OnAdapterChangeListener(){

            public void onAdapterChanged(@NonNull ViewPager viewPager, @Nullable PagerAdapter oldAdapter, @Nullable PagerAdapter newAdapter) {
                TabLayoutHelper.this.handleOnAdapterChanged(viewPager, oldAdapter, newAdapter);
            }
        };
        this.setupWithViewPager(this.mTabLayout, this.mViewPager);
    }

    public TabLayout getTabLayout() {
        return this.mTabLayout;
    }

    public ViewPager getViewPager() {
        return this.mViewPager;
    }

    public void setAutoAdjustTabModeEnabled(boolean enabled) {
        if (this.mAutoAdjustTabMode == enabled) {
            return;
        }
        this.mAutoAdjustTabMode = enabled;
        if (this.mAutoAdjustTabMode) {
            this.adjustTabMode(-1);
        } else {
            this.cancelPendingAdjustTabMode();
        }
    }

    public boolean isAutoAdjustTabModeEnabled() {
        return this.mAutoAdjustTabMode;
    }

    @Deprecated
    public void setOnTabSelectedListener(TabLayout.OnTabSelectedListener listener) {
        this.mUserOnTabSelectedListener = listener;
    }

    public void release() {
        this.cancelPendingAdjustTabMode();
        this.cancelPendingSetTabsFromPagerAdapter();
        this.cancelPendingUpdateScrollPosition();
        if (this.mInternalOnAdapterChangeListener != null) {
            this.mViewPager.removeOnAdapterChangeListener(this.mInternalOnAdapterChangeListener);
            this.mInternalOnAdapterChangeListener = null;
        }
        if (this.mInternalDataSetObserver != null) {
            this.mViewPager.getAdapter().unregisterDataSetObserver(this.mInternalDataSetObserver);
            this.mInternalDataSetObserver = null;
        }
        if (this.mInternalOnTabSelectedListener != null) {
            this.mTabLayout.removeOnTabSelectedListener((TabLayout.BaseOnTabSelectedListener)this.mInternalOnTabSelectedListener);
            this.mInternalOnTabSelectedListener = null;
        }
        if (this.mInternalTabLayoutOnPageChangeListener != null) {
            this.mViewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this.mInternalTabLayoutOnPageChangeListener);
            this.mInternalTabLayoutOnPageChangeListener = null;
        }
        this.mUserOnTabSelectedListener = null;
        this.mViewPager = null;
        this.mTabLayout = null;
    }

    public void updateAllTabs() {
        int count = this.mTabLayout.getTabCount();
        for (int i = 0; i < count; ++i) {
            this.updateTab(this.mTabLayout.getTabAt(i));
        }
    }

    protected TabLayout.Tab onCreateTab(TabLayout tabLayout, PagerAdapter adapter, int position) {
        TabLayout.Tab tab = tabLayout.newTab();
        tab.setText(adapter.getPageTitle(position));
        return tab;
    }

    protected void onUpdateTab(TabLayout.Tab tab) {
        if (tab.getCustomView() == null) {
            tab.setCustomView(null);
        }
    }

    protected void handleOnDataSetChanged() {
        this.cancelPendingUpdateScrollPosition();
        this.cancelPendingSetTabsFromPagerAdapter();
        if (this.mSetTabsFromPagerAdapterRunnable == null) {
            this.mSetTabsFromPagerAdapterRunnable = new Runnable(){

                @Override
                public void run() {
                    TabLayoutHelper.this.setTabsFromPagerAdapter(TabLayoutHelper.this.mTabLayout, TabLayoutHelper.this.mViewPager.getAdapter(), TabLayoutHelper.this.mViewPager.getCurrentItem());
                }
            };
        }
        this.mTabLayout.post(this.mSetTabsFromPagerAdapterRunnable);
    }

    protected void handleOnTabSelected(TabLayout.Tab tab) {
        if (this.mDuringSetTabsFromPagerAdapter) {
            return;
        }
        this.mViewPager.setCurrentItem(tab.getPosition());
        this.cancelPendingUpdateScrollPosition();
        if (this.mUserOnTabSelectedListener != null) {
            this.mUserOnTabSelectedListener.onTabSelected(tab);
        }
    }

    protected void handleOnTabUnselected(TabLayout.Tab tab) {
        if (this.mDuringSetTabsFromPagerAdapter) {
            return;
        }
        if (this.mUserOnTabSelectedListener != null) {
            this.mUserOnTabSelectedListener.onTabUnselected(tab);
        }
    }

    protected void handleOnTabReselected(TabLayout.Tab tab) {
        if (this.mDuringSetTabsFromPagerAdapter) {
            return;
        }
        if (this.mUserOnTabSelectedListener != null) {
            this.mUserOnTabSelectedListener.onTabReselected(tab);
        }
    }

    protected void handleOnAdapterChanged(ViewPager viewPager, PagerAdapter oldAdapter, PagerAdapter newAdapter) {
        if (this.mViewPager != viewPager) {
            return;
        }
        if (oldAdapter != null) {
            oldAdapter.unregisterDataSetObserver(this.mInternalDataSetObserver);
        }
        if (newAdapter != null) {
            newAdapter.registerDataSetObserver(this.mInternalDataSetObserver);
        }
        this.setTabsFromPagerAdapter(this.mTabLayout, newAdapter, this.mViewPager.getCurrentItem());
    }

    protected void cancelPendingAdjustTabMode() {
        if (this.mAdjustTabModeRunnable != null) {
            this.mTabLayout.removeCallbacks(this.mAdjustTabModeRunnable);
            this.mAdjustTabModeRunnable = null;
        }
    }

    protected void cancelPendingSetTabsFromPagerAdapter() {
        if (this.mSetTabsFromPagerAdapterRunnable != null) {
            this.mTabLayout.removeCallbacks(this.mSetTabsFromPagerAdapterRunnable);
            this.mSetTabsFromPagerAdapterRunnable = null;
        }
    }

    protected void cancelPendingUpdateScrollPosition() {
        if (this.mUpdateScrollPositionRunnable != null) {
            this.mTabLayout.removeCallbacks(this.mUpdateScrollPositionRunnable);
            this.mUpdateScrollPositionRunnable = null;
        }
    }

    protected void adjustTabMode(int prevScrollX) {
        if (this.mAdjustTabModeRunnable != null) {
            return;
        }
        if (prevScrollX < 0) {
            prevScrollX = this.mTabLayout.getScrollX();
        }
        if (ViewCompat.isLaidOut((View)this.mTabLayout)) {
            this.adjustTabModeInternal(this.mTabLayout, prevScrollX);
        } else {
            final int prevScrollX1 = prevScrollX;
            this.mAdjustTabModeRunnable = new Runnable(){

                @Override
                public void run() {
                    TabLayoutHelper.this.mAdjustTabModeRunnable = null;
                    TabLayoutHelper.this.adjustTabModeInternal(TabLayoutHelper.this.mTabLayout, prevScrollX1);
                }
            };
            this.mTabLayout.post(this.mAdjustTabModeRunnable);
        }
    }

    protected TabLayout.Tab createNewTab(TabLayout tabLayout, PagerAdapter adapter, int position) {
        return this.onCreateTab(tabLayout, adapter, position);
    }

    protected void setupWithViewPager(@NonNull TabLayout tabLayout, @NonNull ViewPager viewPager) {
        PagerAdapter adapter = viewPager.getAdapter();
        if (adapter == null) {
            throw new IllegalArgumentException("ViewPager does not have a PagerAdapter set");
        }
        this.setTabsFromPagerAdapter(tabLayout, adapter, viewPager.getCurrentItem());
        viewPager.getAdapter().registerDataSetObserver(this.mInternalDataSetObserver);
        viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this.mInternalTabLayoutOnPageChangeListener);
        viewPager.addOnAdapterChangeListener(this.mInternalOnAdapterChangeListener);
        tabLayout.addOnTabSelectedListener((TabLayout.BaseOnTabSelectedListener)this.mInternalOnTabSelectedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTabsFromPagerAdapter(@NonNull TabLayout tabLayout, @Nullable PagerAdapter adapter, int currentItem) {
        try {
            this.mDuringSetTabsFromPagerAdapter = true;
            int prevSelectedTab = tabLayout.getSelectedTabPosition();
            int prevScrollX = tabLayout.getScrollX();
            tabLayout.removeAllTabs();
            if (adapter != null) {
                int count = adapter.getCount();
                for (int i = 0; i < count; ++i) {
                    TabLayout.Tab tab = this.createNewTab(tabLayout, adapter, i);
                    tabLayout.addTab(tab, false);
                    this.updateTab(tab);
                }
                if ((currentItem = Math.min(currentItem, count - 1)) >= 0) {
                    tabLayout.getTabAt(currentItem).select();
                }
            }
            if (this.mAutoAdjustTabMode) {
                this.adjustTabMode(prevScrollX);
            } else {
                int curTabMode = tabLayout.getTabMode();
                if (curTabMode == 0) {
                    tabLayout.scrollTo(prevScrollX, 0);
                }
            }
        }
        finally {
            this.mDuringSetTabsFromPagerAdapter = false;
        }
    }

    protected void updateTab(TabLayout.Tab tab) {
        this.onUpdateTab(tab);
    }

    protected int determineTabMode(@NonNull TabLayout tabLayout) {
        LinearLayout slidingTabStrip = (LinearLayout)tabLayout.getChildAt(0);
        int childCount = slidingTabStrip.getChildCount();
        int tabLayoutWidth = tabLayout.getMeasuredWidth() - tabLayout.getPaddingLeft() - tabLayout.getPaddingRight();
        int tabLayoutHeight = tabLayout.getMeasuredHeight() - tabLayout.getPaddingTop() - tabLayout.getPaddingBottom();
        if (childCount == 0) {
            return 1;
        }
        int stripWidth = 0;
        int maxWidthTab = 0;
        int tabHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)tabLayoutHeight, (int)0x40000000);
        for (int i = 0; i < childCount; ++i) {
            View tabView = slidingTabStrip.getChildAt(i);
            tabView.measure(0, tabHeightMeasureSpec);
            int tabWidth = tabView.getMeasuredWidth();
            stripWidth += tabWidth;
            maxWidthTab = Math.max(maxWidthTab, tabWidth);
        }
        return stripWidth < tabLayoutWidth && maxWidthTab < tabLayoutWidth / childCount ? 1 : 0;
    }

    protected void adjustTabModeInternal(@NonNull TabLayout tabLayout, int prevScrollX) {
        int prevTabMode = tabLayout.getTabMode();
        tabLayout.setTabMode(0);
        tabLayout.setTabGravity(1);
        int newTabMode = this.determineTabMode(tabLayout);
        this.cancelPendingUpdateScrollPosition();
        if (newTabMode == 1) {
            tabLayout.setTabGravity(0);
            tabLayout.setTabMode(1);
        } else {
            LinearLayout slidingTabStrip = (LinearLayout)tabLayout.getChildAt(0);
            slidingTabStrip.setGravity(1);
            if (prevTabMode == 0) {
                tabLayout.scrollTo(prevScrollX, 0);
            } else {
                this.mUpdateScrollPositionRunnable = new Runnable(){

                    @Override
                    public void run() {
                        TabLayoutHelper.this.mUpdateScrollPositionRunnable = null;
                        TabLayoutHelper.this.updateScrollPosition();
                    }
                };
                this.mTabLayout.post(this.mUpdateScrollPositionRunnable);
            }
        }
    }

    private void updateScrollPosition() {
        this.mTabLayout.setScrollPosition(this.mTabLayout.getSelectedTabPosition(), 0.0f, false);
    }

    static class Internal {
        private static final Method mMethodSelectTab = Internal.getAccessiblePrivateMethod(TabLayout.class, "selectTab", TabLayout.Tab.class, Boolean.TYPE);

        Internal() {
        }

        private static Method getAccessiblePrivateMethod(Class<?> targetClass, String methodName, Class<?> ... params) throws RuntimeException {
            try {
                Method m = targetClass.getDeclaredMethod(methodName, params);
                m.setAccessible(true);
                return m;
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
        }

        public static void selectTab(TabLayout tabLayout, TabLayout.Tab tab, boolean updateIndicator) {
            try {
                mMethodSelectTab.invoke((Object)tabLayout, tab, updateIndicator);
            }
            catch (IllegalAccessException e) {
                new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw Internal.handleInvocationTargetException(e);
            }
        }

        private static RuntimeException handleInvocationTargetException(InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            throw new IllegalStateException(targetException);
        }
    }

    protected static class FixedTabLayoutOnPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private final WeakReference<TabLayout> mTabLayoutRef;
        private int mPreviousScrollState;
        private int mScrollState;

        public FixedTabLayoutOnPageChangeListener(TabLayout tabLayout) {
            this.mTabLayoutRef = new WeakReference<TabLayout>(tabLayout);
        }

        public void onPageScrollStateChanged(int state) {
            this.mPreviousScrollState = this.mScrollState;
            this.mScrollState = state;
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            TabLayout tabLayout = (TabLayout)this.mTabLayoutRef.get();
            if (tabLayout != null && this.shouldUpdateScrollPosition()) {
                boolean updateText = this.mScrollState == 1 || this.mScrollState == 2 && this.mPreviousScrollState == 1;
                tabLayout.setScrollPosition(position, positionOffset, updateText);
            }
        }

        public void onPageSelected(int position) {
            TabLayout tabLayout = (TabLayout)this.mTabLayoutRef.get();
            if (tabLayout != null && tabLayout.getSelectedTabPosition() != position) {
                Internal.selectTab(tabLayout, tabLayout.getTabAt(position), this.mScrollState == 0);
            }
        }

        private boolean shouldUpdateScrollPosition() {
            return this.mScrollState == 1 || this.mScrollState == 2 && this.mPreviousScrollState == 1;
        }
    }
}

