/*
 * Decompiled with CFR 0.152.
 */
package com.moments.filepicker.views.magicindicator.buildins.commonnavigator.indicators;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.view.View;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.moments.filepicker.views.magicindicator.FragmentContainerHelper;
import com.moments.filepicker.views.magicindicator.buildins.UIUtil;
import com.moments.filepicker.views.magicindicator.buildins.commonnavigator.abs.IPagerIndicator;
import com.moments.filepicker.views.magicindicator.buildins.commonnavigator.model.PositionData;
import java.util.List;

public class WrapPagerIndicator
extends View
implements IPagerIndicator {
    private int mVerticalPadding;
    private int mHorizontalPadding;
    private int mFillColor;
    private float mRoundRadius;
    private Interpolator mStartInterpolator = new LinearInterpolator();
    private Interpolator mEndInterpolator = new LinearInterpolator();
    private List<PositionData> mPositionDataList;
    private Paint mPaint;
    private RectF mRect = new RectF();
    private boolean mRoundRadiusSet;

    public WrapPagerIndicator(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mVerticalPadding = UIUtil.dip2px(context, 6.0);
        this.mHorizontalPadding = UIUtil.dip2px(context, 10.0);
    }

    protected void onDraw(Canvas canvas) {
        this.mPaint.setColor(this.mFillColor);
        canvas.drawRoundRect(this.mRect, this.mRoundRadius, this.mRoundRadius, this.mPaint);
    }

    @Override
    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mPositionDataList == null || this.mPositionDataList.isEmpty()) {
            return;
        }
        PositionData current = FragmentContainerHelper.getImitativePositionData(this.mPositionDataList, position);
        PositionData next = FragmentContainerHelper.getImitativePositionData(this.mPositionDataList, position + 1);
        this.mRect.left = (float)(current.mContentLeft - this.mHorizontalPadding) + (float)(next.mContentLeft - current.mContentLeft) * this.mEndInterpolator.getInterpolation(positionOffset);
        this.mRect.top = current.mContentTop - this.mVerticalPadding;
        this.mRect.right = (float)(current.mContentRight + this.mHorizontalPadding) + (float)(next.mContentRight - current.mContentRight) * this.mStartInterpolator.getInterpolation(positionOffset);
        this.mRect.bottom = current.mContentBottom + this.mVerticalPadding;
        if (!this.mRoundRadiusSet) {
            this.mRoundRadius = this.mRect.height() / 2.0f;
        }
        this.invalidate();
    }

    @Override
    public void onPageSelected(int position) {
    }

    @Override
    public void onPageScrollStateChanged(int state) {
    }

    @Override
    public void onPositionDataProvide(List<PositionData> dataList) {
        this.mPositionDataList = dataList;
    }

    public Paint getPaint() {
        return this.mPaint;
    }

    public int getVerticalPadding() {
        return this.mVerticalPadding;
    }

    public void setVerticalPadding(int verticalPadding) {
        this.mVerticalPadding = verticalPadding;
    }

    public int getHorizontalPadding() {
        return this.mHorizontalPadding;
    }

    public void setHorizontalPadding(int horizontalPadding) {
        this.mHorizontalPadding = horizontalPadding;
    }

    public int getFillColor() {
        return this.mFillColor;
    }

    public void setFillColor(int fillColor) {
        this.mFillColor = fillColor;
    }

    public float getRoundRadius() {
        return this.mRoundRadius;
    }

    public void setRoundRadius(float roundRadius) {
        this.mRoundRadius = roundRadius;
        this.mRoundRadiusSet = true;
    }

    public Interpolator getStartInterpolator() {
        return this.mStartInterpolator;
    }

    public void setStartInterpolator(Interpolator startInterpolator) {
        this.mStartInterpolator = startInterpolator;
        if (this.mStartInterpolator == null) {
            this.mStartInterpolator = new LinearInterpolator();
        }
    }

    public Interpolator getEndInterpolator() {
        return this.mEndInterpolator;
    }

    public void setEndInterpolator(Interpolator endInterpolator) {
        this.mEndInterpolator = endInterpolator;
        if (this.mEndInterpolator == null) {
            this.mEndInterpolator = new LinearInterpolator();
        }
    }
}

