/*
 * Decompiled with CFR 0.152.
 */
package com.moments.filepicker.views.magicindicator.buildins.commonnavigator.titles;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.TextUtils;
import android.widget.TextView;
import com.moments.filepicker.views.magicindicator.buildins.UIUtil;
import com.moments.filepicker.views.magicindicator.buildins.commonnavigator.abs.IMeasurablePagerTitleView;

public class SimplePagerTitleView
extends TextView
implements IMeasurablePagerTitleView {
    protected int mSelectedColor;
    protected int mNormalColor;
    protected Context context;

    public SimplePagerTitleView(Context context) {
        super(context, null);
        this.init();
        this.context = context;
    }

    private void init() {
        this.setGravity(17);
        this.setSingleLine();
        this.setEllipsize(TextUtils.TruncateAt.END);
    }

    @Override
    public void onSelected(int index, int totalCount) {
        this.setTextColor(this.mSelectedColor);
    }

    @Override
    public void onDeselected(int index, int totalCount) {
        this.setTextColor(this.mNormalColor);
    }

    @Override
    public void onLeave(int index, int totalCount, float leavePercent, boolean leftToRight) {
    }

    @Override
    public void onEnter(int index, int totalCount, float enterPercent, boolean leftToRight) {
    }

    @Override
    public int getContentLeft() {
        Rect bound = new Rect();
        String longestString = "";
        if (this.getText().toString().contains("\n")) {
            String[] brokenStrings;
            for (String each : brokenStrings = this.getText().toString().split("\\n")) {
                if (each.length() <= longestString.length()) continue;
                longestString = each;
            }
        } else {
            longestString = this.getText().toString();
        }
        this.getPaint().getTextBounds(longestString, 0, longestString.length(), bound);
        int contentWidth = bound.width();
        return this.getLeft() + this.getWidth() / 2 - contentWidth / 2;
    }

    @Override
    public int getContentTop() {
        Paint.FontMetrics metrics = this.getPaint().getFontMetrics();
        float contentHeight = metrics.bottom - metrics.top;
        return (int)((float)(this.getHeight() / 2) - contentHeight / 2.0f);
    }

    @Override
    public int getContentRight() {
        Rect bound = new Rect();
        String longestString = "";
        if (this.getText().toString().contains("\n")) {
            String[] brokenStrings;
            for (String each : brokenStrings = this.getText().toString().split("\\n")) {
                if (each.length() <= longestString.length()) continue;
                longestString = each;
            }
        } else {
            longestString = this.getText().toString();
        }
        this.getPaint().getTextBounds(longestString, 0, longestString.length(), bound);
        int contentWidth = bound.width();
        return this.getLeft() + this.getWidth() / 2 + contentWidth / 2;
    }

    @Override
    public int getContentBottom() {
        Paint.FontMetrics metrics = this.getPaint().getFontMetrics();
        float contentHeight = metrics.bottom - metrics.top;
        return (int)((float)(this.getHeight() / 2) + contentHeight / 2.0f);
    }

    public int getSelectedColor() {
        return this.mSelectedColor;
    }

    public void setSelectedColor(int selectedColor) {
        this.mSelectedColor = selectedColor;
    }

    public int getNormalColor() {
        return this.mNormalColor;
    }

    public void setNormalColor(int normalColor) {
        this.mNormalColor = normalColor;
    }

    public void setPadding(int padding) {
        int padding1 = UIUtil.dip2px(this.context, padding);
        this.setPadding(padding1, 0, padding1, 0);
    }
}

