/*
 * Decompiled with CFR 0.152.
 */
package com.moments.filepicker.adapters;

import android.support.v7.widget.RecyclerView;
import com.moments.filepicker.adapters.Selectable;
import com.moments.filepicker.models.BaseFile;
import java.util.ArrayList;
import java.util.List;

public abstract class SelectableAdapter<VH extends RecyclerView.ViewHolder, T extends BaseFile>
extends RecyclerView.Adapter<VH>
implements Selectable<T> {
    private static final String TAG = SelectableAdapter.class.getSimpleName();
    private List<T> items;
    protected List<T> selectedPhotos;

    public SelectableAdapter(List<T> items, List<String> selectedPaths) {
        this.items = items;
        this.selectedPhotos = new ArrayList<T>();
        this.addPathsToSelections(selectedPaths);
    }

    private void addPathsToSelections(List<String> selectedPaths) {
        if (selectedPaths == null) {
            return;
        }
        for (int index = 0; index < this.items.size(); ++index) {
            for (int jindex = 0; jindex < selectedPaths.size(); ++jindex) {
                if (!((BaseFile)this.items.get(index)).getPath().equals(selectedPaths.get(jindex))) continue;
                this.selectedPhotos.add(this.items.get(index));
            }
        }
    }

    @Override
    public boolean isSelected(T photo) {
        return this.selectedPhotos.contains(photo);
    }

    @Override
    public void toggleSelection(T photo) {
        if (this.selectedPhotos.contains(photo)) {
            this.selectedPhotos.remove(photo);
        } else {
            this.selectedPhotos.add(photo);
        }
    }

    @Override
    public void clearSelection() {
        this.selectedPhotos.clear();
        this.notifyDataSetChanged();
    }

    public void selectAll() {
        this.selectedPhotos.clear();
        this.selectedPhotos.addAll(this.items);
        this.notifyDataSetChanged();
    }

    @Override
    public int getSelectedItemCount() {
        return this.selectedPhotos.size();
    }

    public void setData(List<T> items) {
        this.items = items;
    }

    public List<T> getItems() {
        return this.items;
    }

    public ArrayList<String> getSelectedPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        for (int index = 0; index < this.selectedPhotos.size(); ++index) {
            paths.add(((BaseFile)this.selectedPhotos.get(index)).getPath());
        }
        return paths;
    }
}

