/*
 * Decompiled with CFR 0.152.
 */
package com.moments.filepicker.fragments;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SearchView;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.moments.filepicker.PickerManager;
import com.moments.filepicker.R;
import com.moments.filepicker.adapters.FileAdapterListener;
import com.moments.filepicker.adapters.FileListAdapter;
import com.moments.filepicker.fragments.BaseFragment;
import com.moments.filepicker.models.BaseFile;
import com.moments.filepicker.models.FileType;
import com.moments.filepicker.models.PickFile;
import com.moments.filepicker.models.sort.resort.NameReComparator;
import com.moments.filepicker.models.sort.resort.TimeReComparator;
import com.moments.filepicker.selection.ItemClickListener;
import com.moments.filepicker.selection.Section;
import com.moments.filepicker.utils.FileUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class FileFragment
extends BaseFragment
implements FileAdapterListener,
ItemClickListener {
    private static final String TAG = FileFragment.class.getSimpleName();
    RecyclerView recyclerView;
    TextView emptyView;
    private DocFragmentListener mListener;
    private MenuItem selectAllItem;
    private FileListAdapter fileListAdapter;
    private CopyOnWriteArrayList<BaseFile> fileList = new CopyOnWriteArrayList();
    private Map<String, List<BaseFile>> selectionMap = new HashMap<String, List<BaseFile>>();
    private List<BaseFile> wordFileList = new ArrayList<BaseFile>();
    private List<BaseFile> excelFileList = new ArrayList<BaseFile>();
    private List<BaseFile> pptFileList = new ArrayList<BaseFile>();
    private List<BaseFile> pdfFileList = new ArrayList<BaseFile>();
    private List<BaseFile> txtFileList = new ArrayList<BaseFile>();
    private List<String> selectionList = new ArrayList<String>();
    private List<String> docSelectionList = new ArrayList<String>();

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.moments_filepicker_fragment_photo_picker, container, false);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof DocFragmentListener)) {
            throw new RuntimeException(context.toString() + " must implement PhotoPickerFragmentListener");
        }
        this.mListener = (DocFragmentListener)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mListener = null;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
    }

    public static FileFragment newInstance(FileType fileType) {
        FileFragment photoPickerFragment = new FileFragment();
        Bundle bun = new Bundle();
        bun.putParcelable("FILE_TYPE", (Parcelable)fileType);
        photoPickerFragment.setArguments(bun);
        return photoPickerFragment;
    }

    public FileType getFileType() {
        return (FileType)this.getArguments().getParcelable("FILE_TYPE");
    }

    @Override
    public void onItemSelected() {
        this.mListener.onItemSelected();
        if (this.fileListAdapter != null && this.selectAllItem != null && this.fileListAdapter.getItemCount() == this.fileListAdapter.getSelectedItemCount()) {
            this.selectAllItem.setIcon(R.drawable.filepicker_ic_select_all);
            this.selectAllItem.setChecked(true);
        }
    }

    @Override
    public void itemClicked(Section section, int position) {
        if (section.isExpanded()) {
            for (BaseFile baseFile : this.fileList) {
                if (baseFile instanceof PickFile) {
                    String fileExtString = FileUtils.getFileExtString(baseFile.getPath());
                    if (!fileExtString.equals(section.getName()) && !((PickFile)baseFile).getDir().equals(section.getName())) continue;
                    this.fileList.remove(baseFile);
                    continue;
                }
                if (!(baseFile instanceof Section) || !section.getName().equals(((Section)baseFile).getName())) continue;
                ((Section)baseFile).setExpanded(!((Section)baseFile).isExpanded());
            }
        } else {
            List<BaseFile> baseFiles = this.selectionMap.get(section.getName());
            for (int i = 0; i < this.fileList.size(); ++i) {
                BaseFile baseFile = this.fileList.get(i);
                if (!(baseFile instanceof Section) || !section.getName().equals(((Section)baseFile).getName())) continue;
                this.fileList.addAll(i + 1, baseFiles);
                ((Section)baseFile).setExpanded(!((Section)baseFile).isExpanded());
                break;
            }
        }
        this.fileListAdapter.notifyDataSetChanged();
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView(view);
    }

    private void initView(View view) {
        this.recyclerView = (RecyclerView)view.findViewById(R.id.recyclerview);
        this.emptyView = (TextView)view.findViewById(R.id.empty_view);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        this.recyclerView.setVisibility(8);
    }

    public void updateList(List<PickFile> dirs) {
        if (this.getView() == null) {
            return;
        }
        if (dirs.size() > 0) {
            this.recyclerView.setVisibility(0);
            this.emptyView.setVisibility(8);
            for (int i = 0; i < dirs.size(); ++i) {
                String fileExtStringCurrent = FileUtils.getFileExtString(dirs.get(i).getPath());
                String dir = dirs.get(i).getDir();
                switch (fileExtStringCurrent) {
                    case "WORD": {
                        this.wordFileList.add(dirs.get(i));
                        break;
                    }
                    case "PPT": {
                        this.pptFileList.add(dirs.get(i));
                        break;
                    }
                    case "EXCEL": {
                        this.excelFileList.add(dirs.get(i));
                        break;
                    }
                    case "PDF": {
                        this.pdfFileList.add(dirs.get(i));
                        break;
                    }
                    case "TXT": {
                        this.txtFileList.add(dirs.get(i));
                        break;
                    }
                    default: {
                        List<BaseFile> baseFiles = this.selectionMap.get(dir);
                        if (baseFiles == null) {
                            ArrayList<PickFile> temp = new ArrayList<PickFile>();
                            temp.add(dirs.get(i));
                            this.selectionMap.put(dir, temp);
                            break;
                        }
                        baseFiles.add(dirs.get(i));
                        this.selectionMap.put(dir, baseFiles);
                    }
                }
                if (FileUtils.isAllDoucmentFile(dirs.get(i).getPath())) {
                    if (this.contain(fileExtStringCurrent, this.docSelectionList)) {
                        this.fileList.add(dirs.get(i));
                        continue;
                    }
                    this.docSelectionList.add(fileExtStringCurrent);
                    this.fileList.add(new Section(fileExtStringCurrent));
                    this.fileList.add(dirs.get(i));
                    continue;
                }
                if (i == 0) {
                    this.selectionList.add(dir);
                    this.fileList.add(new Section(dir));
                    this.fileList.add(dirs.get(i));
                    continue;
                }
                String dirLast = dirs.get(i - 1).getDir();
                if (dir.equals(dirLast) || this.contain(dir, this.selectionList)) {
                    this.fileList.add(dirs.get(i));
                    continue;
                }
                this.selectionList.add(dir);
                this.fileList.add(new Section(dir));
                this.fileList.add(dirs.get(i));
            }
            this.selectionMap.put("WORD", this.wordFileList);
            this.selectionMap.put("PPT", this.pptFileList);
            this.selectionMap.put("EXCEL", this.excelFileList);
            this.selectionMap.put("PDF", this.pdfFileList);
            this.selectionMap.put("TXT", this.txtFileList);
            this.initSection();
            this.reSortSection();
            this.reSortFile();
            this.fileListAdapter = (FileListAdapter)this.recyclerView.getAdapter();
            if (this.fileListAdapter == null) {
                this.fileListAdapter = new FileListAdapter((Context)this.getActivity(), this.fileList, PickerManager.getInstance().getSelectedFiles(), this, this);
                this.recyclerView.setAdapter((RecyclerView.Adapter)this.fileListAdapter);
            } else {
                this.fileListAdapter.setData(this.fileList);
                this.fileListAdapter.notifyDataSetChanged();
            }
            this.onItemSelected();
        } else {
            this.recyclerView.setVisibility(8);
            this.emptyView.setVisibility(0);
        }
    }

    private void reSortFile() {
        TimeReComparator timeReComparator = new TimeReComparator();
        for (Map.Entry<String, List<BaseFile>> entry : this.selectionMap.entrySet()) {
            Collections.sort(entry.getValue(), timeReComparator);
        }
    }

    private void initSection() {
        for (BaseFile baseFile : this.fileList) {
            if (!(baseFile instanceof PickFile)) continue;
            this.fileList.remove(baseFile);
        }
    }

    private void reSortSection() {
        ArrayList<BaseFile> temp = new ArrayList<BaseFile>(this.fileList);
        Collections.sort(temp, new NameReComparator());
        this.fileList.clear();
        this.fileList.addAll(temp);
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        inflater.inflate(R.menu.filepicker_doc_picker_menu, menu2);
        this.selectAllItem = menu2.findItem(R.id.action_select);
        if (!PickerManager.getInstance().hasSelectAll()) {
            MenuItem search = menu2.findItem(R.id.search);
            SearchView searchView = (SearchView)search.getActionView();
            searchView.setOnQueryTextListener(new SearchView.OnQueryTextListener(){

                public boolean onQueryTextSubmit(String query) {
                    return false;
                }

                public boolean onQueryTextChange(String newText) {
                    if (FileFragment.this.fileListAdapter != null) {
                        FileFragment.this.fileListAdapter.getFilter().filter((CharSequence)newText);
                    }
                    return true;
                }
            });
            this.selectAllItem.setVisible(false);
        }
        super.onCreateOptionsMenu(menu2, inflater);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int itemId = item.getItemId();
        if (itemId == R.id.action_select) {
            if (this.fileListAdapter != null) {
                if (this.selectAllItem != null) {
                    if (this.selectAllItem.isChecked()) {
                        this.fileListAdapter.clearSelection();
                        PickerManager.getInstance().clearSelections();
                        this.selectAllItem.setIcon(R.drawable.filepicker_ic_deselect_all);
                    } else {
                        this.fileListAdapter.selectAll();
                        PickerManager.getInstance().add(this.fileListAdapter.getSelectedPaths(), 2);
                        this.selectAllItem.setIcon(R.drawable.filepicker_ic_select_all);
                    }
                }
                this.selectAllItem.setChecked(!this.selectAllItem.isChecked());
                this.mListener.onItemSelected();
            }
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private boolean contain(String selection, List<String> selections) {
        for (String fileExt : selections) {
            if (!fileExt.equals(selection)) continue;
            return true;
        }
        return false;
    }

    public static interface DocFragmentListener {
        public void onItemSelected();
    }
}

