/*
 * Decompiled with CFR 0.152.
 */
package com.moments.filepicker.views.magicindicator;

import android.content.Context;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.moments.filepicker.views.magicindicator.abs.IPagerNavigator;

public class MagicIndicator
extends FrameLayout {
    private IPagerNavigator mNavigator;

    public MagicIndicator(Context context) {
        this(context, null);
    }

    public MagicIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MagicIndicator(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setBackgroundResource(@DrawableRes int resId) {
        super.setBackgroundResource(resId);
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mNavigator != null) {
            this.mNavigator.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
    }

    public void onPageSelected(int position) {
        if (this.mNavigator != null) {
            this.mNavigator.onPageSelected(position);
        }
    }

    public void onPageScrollStateChanged(int state) {
        if (this.mNavigator != null) {
            this.mNavigator.onPageScrollStateChanged(state);
        }
    }

    public IPagerNavigator getNavigator() {
        return this.mNavigator;
    }

    public void setNavigator(IPagerNavigator navigator) {
        if (this.mNavigator == navigator) {
            return;
        }
        if (this.mNavigator != null) {
            this.mNavigator.onDetachFromMagicIndicator();
        }
        this.mNavigator = navigator;
        this.removeAllViews();
        if (this.mNavigator instanceof View) {
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
            this.addView((View)this.mNavigator, (ViewGroup.LayoutParams)lp);
            this.mNavigator.onAttachToMagicIndicator();
        }
    }
}

