/*
 * Decompiled with CFR 0.152.
 */
package com.moments.filepicker.views.magicindicator;

import android.util.SparseArray;
import android.util.SparseBooleanArray;

public class NavigatorHelper {
    private SparseBooleanArray mDeselectedItems = new SparseBooleanArray();
    private SparseArray<Float> mLeavedPercents = new SparseArray();
    private int mTotalCount;
    private int mCurrentIndex;
    private int mLastIndex;
    private float mLastPositionOffsetSum;
    private int mScrollState;
    private boolean mSkimOver;
    private OnNavigatorScrollListener mNavigatorScrollListener;

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        float currentPositionOffsetSum = (float)position + positionOffset;
        boolean leftToRight = false;
        if (this.mLastPositionOffsetSum <= currentPositionOffsetSum) {
            leftToRight = true;
        }
        if (this.mScrollState != 0) {
            if (currentPositionOffsetSum == this.mLastPositionOffsetSum) {
                return;
            }
            int nextPosition = position + 1;
            boolean normalDispatch = true;
            if (positionOffset == 0.0f && leftToRight) {
                nextPosition = position - 1;
                normalDispatch = false;
            }
            for (int i = 0; i < this.mTotalCount; ++i) {
                Float leavedPercent;
                if (i == position || i == nextPosition || (leavedPercent = (Float)this.mLeavedPercents.get(i, (Object)Float.valueOf(0.0f))).floatValue() == 1.0f) continue;
                this.dispatchOnLeave(i, 1.0f, leftToRight, true);
            }
            if (normalDispatch) {
                if (leftToRight) {
                    this.dispatchOnLeave(position, positionOffset, true, false);
                    this.dispatchOnEnter(nextPosition, positionOffset, true, false);
                } else {
                    this.dispatchOnLeave(nextPosition, 1.0f - positionOffset, false, false);
                    this.dispatchOnEnter(position, 1.0f - positionOffset, false, false);
                }
            } else {
                this.dispatchOnLeave(nextPosition, 1.0f - positionOffset, true, false);
                this.dispatchOnEnter(position, 1.0f - positionOffset, true, false);
            }
        } else {
            for (int i = 0; i < this.mTotalCount; ++i) {
                Float leavedPercent;
                if (i == this.mCurrentIndex) continue;
                boolean deselected = this.mDeselectedItems.get(i);
                if (!deselected) {
                    this.dispatchOnDeselected(i);
                }
                if ((leavedPercent = (Float)this.mLeavedPercents.get(i, (Object)Float.valueOf(0.0f))).floatValue() == 1.0f) continue;
                this.dispatchOnLeave(i, 1.0f, false, true);
            }
            this.dispatchOnEnter(this.mCurrentIndex, 1.0f, false, true);
            this.dispatchOnSelected(this.mCurrentIndex);
        }
        this.mLastPositionOffsetSum = currentPositionOffsetSum;
    }

    private void dispatchOnEnter(int index, float enterPercent, boolean leftToRight, boolean force) {
        if (this.mSkimOver || index == this.mCurrentIndex || this.mScrollState == 1 || force) {
            if (this.mNavigatorScrollListener != null) {
                this.mNavigatorScrollListener.onEnter(index, this.mTotalCount, enterPercent, leftToRight);
            }
            this.mLeavedPercents.put(index, (Object)Float.valueOf(1.0f - enterPercent));
        }
    }

    private void dispatchOnLeave(int index, float leavePercent, boolean leftToRight, boolean force) {
        if (this.mSkimOver || index == this.mLastIndex || this.mScrollState == 1 || (index == this.mCurrentIndex - 1 || index == this.mCurrentIndex + 1) && ((Float)this.mLeavedPercents.get(index, (Object)Float.valueOf(0.0f))).floatValue() != 1.0f || force) {
            if (this.mNavigatorScrollListener != null) {
                this.mNavigatorScrollListener.onLeave(index, this.mTotalCount, leavePercent, leftToRight);
            }
            this.mLeavedPercents.put(index, (Object)Float.valueOf(leavePercent));
        }
    }

    private void dispatchOnSelected(int index) {
        if (this.mNavigatorScrollListener != null) {
            this.mNavigatorScrollListener.onSelected(index, this.mTotalCount);
        }
        this.mDeselectedItems.put(index, false);
    }

    private void dispatchOnDeselected(int index) {
        if (this.mNavigatorScrollListener != null) {
            this.mNavigatorScrollListener.onDeselected(index, this.mTotalCount);
        }
        this.mDeselectedItems.put(index, true);
    }

    public void onPageSelected(int position) {
        this.mLastIndex = this.mCurrentIndex;
        this.mCurrentIndex = position;
        this.dispatchOnSelected(this.mCurrentIndex);
        for (int i = 0; i < this.mTotalCount; ++i) {
            boolean deselected;
            if (i == this.mCurrentIndex || (deselected = this.mDeselectedItems.get(i))) continue;
            this.dispatchOnDeselected(i);
        }
    }

    public void onPageScrollStateChanged(int state) {
        this.mScrollState = state;
    }

    public void setNavigatorScrollListener(OnNavigatorScrollListener navigatorScrollListener) {
        this.mNavigatorScrollListener = navigatorScrollListener;
    }

    public void setSkimOver(boolean skimOver) {
        this.mSkimOver = skimOver;
    }

    public int getTotalCount() {
        return this.mTotalCount;
    }

    public void setTotalCount(int totalCount) {
        this.mTotalCount = totalCount;
        this.mDeselectedItems.clear();
        this.mLeavedPercents.clear();
    }

    public int getCurrentIndex() {
        return this.mCurrentIndex;
    }

    public int getScrollState() {
        return this.mScrollState;
    }

    public static interface OnNavigatorScrollListener {
        public void onEnter(int var1, int var2, float var3, boolean var4);

        public void onLeave(int var1, int var2, float var3, boolean var4);

        public void onSelected(int var1, int var2);

        public void onDeselected(int var1, int var2);
    }
}

